/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user;

import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import io.atlassian.fugue.Checked;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.jetbrains.annotations.Nullable;

public class BambooRemoteUserUtils {
    private static final String ANONYMOUS_USER = "anonymousUser";

    @Nullable
    public static String getRemoteUsername(HttpServletRequest httpServletRequest) {
        if (httpServletRequest != null) {
            return (String)Checked.now(() -> SecurityConfigFactory.getInstance(null)).flatMap(sc -> Checked.now(() -> ((SecurityConfig)sc).getAuthenticator())).flatMap(sc -> Checked.now(() -> sc.getRemoteUser(httpServletRequest))).getOrElse(() -> null);
        }
        return null;
    }

    @Nullable
    public static String getRemoteUsername() {
        String username;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && !ANONYMOUS_USER.equals(username = authentication.getName())) {
            return username;
        }
        return null;
    }
}

