/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.persistence.BambooObjectDao;
import com.atlassian.bamboo.security.acegi.acls.dto.AceDto;
import com.atlassian.bamboo.security.acegi.acls.dto.AclDto;
import com.atlassian.bamboo.utils.collection.multimap.Multimap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.OwnershipAcl;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.Sid;
import org.jetbrains.annotations.NotNull;

public interface AclDao
extends BambooObjectDao {
    public List<ObjectIdentity> findAclObjectWithParent(ObjectIdentity var1);

    public Map<ObjectIdentity, MutableAcl> findAcls(ObjectIdentity var1);

    public void save(Acl var1);

    public void remove(Acl var1);

    public void removeForIdentity(ObjectIdentity var1);

    public List<AccessControlEntry> findAcesForSid(Sid var1);

    public boolean hasAcesForSid(Sid var1);

    public List<OwnershipAcl> findAclsOwnedBySid(Sid var1);

    @NotNull
    public Map<ObjectIdentity, MutableAcl> findAllAcls();

    @Deprecated
    public MutableAcl findAcl(long var1);

    @Internal
    @NotNull
    public Map<ObjectIdentity, AclDto> findAllAclDtos();

    @Internal
    @NotNull
    public Multimap<Long, AceDto> findAllAces();

    public static class ObjectIdentityDto
    implements ObjectIdentity {
        private final Serializable identifier;
        private final Class javaType;

        public ObjectIdentityDto(ObjectIdentity objectIdentity) {
            this.identifier = objectIdentity.getIdentifier();
            this.javaType = objectIdentity.getJavaType();
        }

        public Serializable getIdentifier() {
            return this.identifier;
        }

        public Class getJavaType() {
            return this.javaType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ObjectIdentityDto)) {
                return false;
            }
            ObjectIdentityDto that = (ObjectIdentityDto)o;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.javaType, that.javaType);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.javaType);
        }
    }
}

