/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.BambooDateUtils;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class ResultsSummaryCriteria
implements Cloneable {
    private static final Logger log = Logger.getLogger(ResultsSummaryCriteria.class);
    private String buildKey;
    private BuildState buildState;
    private Date fromDate;
    private Date toDate;
    private Boolean toDateIsNull;
    private Date fromCreationDate;
    private Date toCreationDate;
    private int fromBuildNumber;
    private int toBuildNumber;
    private Long agentId;
    private List<Label> matchesLabels;
    private List<String> matchesJiraIssues;
    private List<String> matchesCustomDataKeys;
    private int firstResult;
    private int maxRowCount;
    private boolean sorted = true;
    private String sortField;
    private boolean sortAscending;
    private Optional<Boolean> continuable = Optional.empty();
    private Class<? extends ResultsSummary> resultSummaryClass = ResultsSummary.class;
    private Set<LifeCycleState> lifeCycleStates = EnumSet.of(LifeCycleState.FINISHED);
    private Set<String> projectKeys;
    private Boolean isSpecsResult;
    private Boolean isOnceOff;
    private Integer maxFormatVersion;

    public ResultsSummaryCriteria() {
    }

    public ResultsSummaryCriteria(Class<? extends ResultsSummary> resultSummaryClass) {
        this.resultSummaryClass = resultSummaryClass;
    }

    public ResultsSummaryCriteria(String buildKey, Date fromDate, Date toDate) {
        this.buildKey = buildKey;
        this.fromDate = fromDate;
        this.toDate = toDate;
    }

    public ResultsSummaryCriteria(String buildKey, int fromBuildNumber, int toBuildNumber) {
        this.buildKey = buildKey;
        this.fromBuildNumber = fromBuildNumber;
        this.toBuildNumber = toBuildNumber;
    }

    public ResultsSummaryCriteria(String buildKey, Date fromDate, Date toDate, int fromBuildNumber, int toBuildNumber) {
        this.buildKey = buildKey;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.fromBuildNumber = fromBuildNumber;
        this.toBuildNumber = toBuildNumber;
    }

    public ResultsSummaryCriteria(String buildKey) {
        this.buildKey = buildKey;
    }

    public ResultsSummaryCriteria(String planKey, boolean sortAscending) {
        this.buildKey = planKey;
        this.sortAscending = sortAscending;
    }

    public ResultsSummaryCriteria(String planKey, int numberOfResults) {
        this.buildKey = planKey;
        this.maxRowCount = numberOfResults;
    }

    public ResultsSummaryCriteria(String planKey, BuildState buildState) {
        this.buildKey = planKey;
        this.buildState = buildState;
    }

    @Nullable
    public Set<String> getProjectKeys() {
        return this.projectKeys;
    }

    public ResultsSummaryCriteria setProjectKeys(Iterable<String> projectKeys) {
        this.projectKeys = Sets.newHashSet(projectKeys);
        return this;
    }

    public BuildState getBuildState() {
        return this.buildState;
    }

    public void setBuildState(BuildState buildState) {
        this.buildState = buildState;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    @Nullable
    public Boolean getToDateIsNull() {
        return this.toDateIsNull;
    }

    public Date getFromCreationDate() {
        return this.fromCreationDate;
    }

    public void setFromCreationDate(Date fromCreationDate) {
        this.fromCreationDate = fromCreationDate;
    }

    public Date getToCreationDate() {
        return this.toCreationDate;
    }

    public void setToCreationDate(Date toCreationDate) {
        this.toCreationDate = toCreationDate;
    }

    public int getFromBuildNumber() {
        return this.fromBuildNumber;
    }

    public int getToBuildNumber() {
        return this.toBuildNumber;
    }

    public String getBuildKey() {
        return this.buildKey;
    }

    public List<Label> getMatchesLabels() {
        return this.matchesLabels;
    }

    public List<String> getMatchesJiraIssues() {
        return this.matchesJiraIssues;
    }

    public void setMatchesJiraIssues(List<String> matchesJiraIssues) {
        this.matchesJiraIssues = matchesJiraIssues;
    }

    public void setMatchesLabels(List<Label> matchesLabels) {
        this.matchesLabels = matchesLabels;
    }

    public List<String> getMatchesCustomDataKeys() {
        return this.matchesCustomDataKeys;
    }

    public void setMatchesCustomDataKeys(List<String> matchesCustomDataKeys) {
        this.matchesCustomDataKeys = matchesCustomDataKeys;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = BambooDateUtils.makeReasonableDate(fromDate);
    }

    public void setToDate(Date toDate) {
        this.toDate = BambooDateUtils.makeReasonableDate(toDate);
    }

    public void setToDateIsNull(@Nullable Boolean toDateIsNull) {
        this.toDateIsNull = toDateIsNull;
    }

    public void setFromBuildNumber(int fromBuildNumber) {
        this.fromBuildNumber = fromBuildNumber;
    }

    public Long getAgentId() {
        return this.agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public void setMaxRowCount(int maxRowCount) {
        this.maxRowCount = maxRowCount;
    }

    public void setToBuildNumber(int toBuildNumber) {
        this.toBuildNumber = toBuildNumber;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public Collection<LifeCycleState> getLifeCycleStates() {
        return this.lifeCycleStates;
    }

    public void setLifeCycleStates(Set<LifeCycleState> lifeCycleStates) {
        this.lifeCycleStates = lifeCycleStates;
    }

    public Optional<Boolean> isContinuable() {
        return this.continuable;
    }

    public void setContinuable(boolean continuable) {
        this.continuable = Optional.of(continuable);
    }

    @NotNull
    public Class<? extends ResultsSummary> getResultSummaryClass() {
        return this.resultSummaryClass;
    }

    public void setResultSummaryClass(@NotNull Class<? extends ResultsSummary> resultSummaryClass) {
        this.resultSummaryClass = resultSummaryClass;
    }

    public Optional<Boolean> isSpecsResult() {
        return Optional.ofNullable(this.isSpecsResult);
    }

    public void setSpecsResult(boolean isSpecsResult) {
        this.isSpecsResult = isSpecsResult;
    }

    public Optional<Integer> getMaxFormatVersion() {
        return Optional.ofNullable(this.maxFormatVersion);
    }

    public void setMaxFormatVersion(int maxFormatVersion) {
        this.maxFormatVersion = maxFormatVersion;
    }

    public Optional<Boolean> isOnceOff() {
        return Optional.ofNullable(this.isOnceOff);
    }

    public void setOnceOff(boolean onceOff) {
        this.isOnceOff = onceOff;
    }

    public ResultsSummaryCriteria clone() {
        try {
            ResultsSummaryCriteria clone = (ResultsSummaryCriteria)super.clone();
            if (this.matchesLabels != null) {
                clone.setMatchesLabels(new ArrayList<Label>(this.matchesLabels));
            }
            if (this.matchesJiraIssues != null) {
                clone.setMatchesJiraIssues(new ArrayList<String>(this.matchesJiraIssues));
            }
            if (this.matchesCustomDataKeys != null) {
                clone.setMatchesCustomDataKeys(new ArrayList<String>(this.matchesCustomDataKeys));
            }
            return clone;
        }
        catch (Exception e) {
            log.warn((Object)("Unable to clone " + String.valueOf(this)), (Throwable)e);
            throw new RuntimeException("Unable to clone " + String.valueOf(this), e);
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectKeys, this.buildKey, this.fromBuildNumber, this.toBuildNumber, this.fromDate, this.toDate, this.resultSummaryClass, this.lifeCycleStates, this.continuable, this.isSpecsResult, this.isOnceOff, this.maxFormatVersion});
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResultsSummaryCriteria)) {
            return false;
        }
        ResultsSummaryCriteria rhs = (ResultsSummaryCriteria)o;
        return new EqualsBuilder().append(this.getProjectKeys(), rhs.getProjectKeys()).append((Object)this.getBuildKey(), (Object)rhs.getBuildKey()).append(this.getFromBuildNumber(), rhs.getFromBuildNumber()).append(this.getToBuildNumber(), rhs.getToBuildNumber()).append((Object)this.getFromDate(), (Object)rhs.getFromDate()).append((Object)this.getToDate(), (Object)rhs.getToDate()).append(this.getResultSummaryClass(), rhs.getResultSummaryClass()).append(this.getLifeCycleStates(), rhs.getLifeCycleStates()).append(this.isContinuable(), rhs.isContinuable()).append(this.isSpecsResult(), rhs.isSpecsResult()).append(this.isOnceOff(), rhs.isOnceOff()).append(this.getMaxFormatVersion(), rhs.getMaxFormatVersion()).isEquals();
    }

    public int compareTo(Object obj) {
        ResultsSummaryCriteria o = (ResultsSummaryCriteria)obj;
        return new CompareToBuilder().append(this.getProjectKeys(), o.getProjectKeys()).append((Object)this.getBuildKey(), (Object)o.getBuildKey()).append(this.getFromBuildNumber(), o.getFromBuildNumber()).append(this.getToBuildNumber(), o.getToBuildNumber()).append((Object)this.getFromDate(), (Object)o.getFromDate()).append((Object)this.getToDate(), (Object)o.getToDate()).append(this.getResultSummaryClass(), o.getResultSummaryClass()).append(this.getLifeCycleStates(), o.getLifeCycleStates()).append(this.isContinuable(), o.isContinuable()).append(this.isSpecsResult(), o.isSpecsResult()).append(this.isOnceOff(), o.isOnceOff()).append(this.getMaxFormatVersion(), o.getMaxFormatVersion()).toComparison();
    }
}

