/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public final class OptimisticLockingVersionMissesCounter {
    private final AtomicLong counter = new AtomicLong(0L);

    private OptimisticLockingVersionMissesCounter() {
    }

    public void increment() {
        this.counter.updateAndGet(current -> current == Long.MAX_VALUE ? 0L : current + 1L);
    }

    public long getAndReset() {
        return this.counter.getAndSet(0L);
    }

    @NotNull
    public static OptimisticLockingVersionMissesCounter create() {
        return new OptimisticLockingVersionMissesCounter();
    }
}

