/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.bamboo.plan.FilteringPlanManager;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plan.cache.PlanBranchGist;
import com.atlassian.bamboo.plan.cache.index.PlanRepositoryIndex;
import com.atlassian.bamboo.project.Project;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CachedPlanManager
extends FilteringPlanManager {
    @Nullable
    public ImmutablePlan getPlanByKey(@NotNull PlanKey var1);

    @Nullable
    public ImmutablePlan getPlanByKeyWithConsistencyGuarantee(@NotNull PlanKey var1);

    @Nullable
    public <T extends ImmutablePlan> T getPlanByKey(@NotNull PlanKey var1, Class<T> var2) throws IncorrectPlanTypeException;

    @Nullable
    public <T extends ImmutablePlan> T getPlanByKeyWithConsistencyGuarantee(@NotNull PlanKey var1, Class<T> var2) throws IncorrectPlanTypeException;

    @Nullable
    public <T extends ImmutablePlan> T getPlanByKeyIfOfType(@NotNull PlanKey var1, @NotNull Class<T> var2);

    @Nullable
    public <T extends ImmutablePlan> T getPlanByKeyIfOfTypeWithConsistencyGuarantee(@NotNull PlanKey var1, @NotNull Class<T> var2);

    @Override
    public Optional<ImmutableChain> getAnyPlan(Predicate<? super ImmutableChain> var1);

    public Optional<ImmutableChain> getAnyPlanUnrestricted(Predicate<? super ImmutableChain> var1);

    @Nullable
    public <T extends ImmutablePlan> T getPlanById(long var1, Class<T> var3) throws IncorrectPlanTypeException, NoSuchElementException;

    @Nullable
    public <T extends ImmutablePlan> T getPlanByIdNotThrowing(long var1, Class<T> var3);

    @Nullable
    public <T extends ImmutablePlan> T getPlanByIdNotThrowingWithConsistencyGuarantee(long var1, Class<T> var3);

    @NotNull
    public List<ImmutableTopLevelPlan> getPlansUnrestricted();

    @NotNull
    public List<ImmutableTopLevelPlan> getPlansUnrestrictedWithConsistencyGuarantee();

    @NotNull
    public List<ImmutableChain> getPlansByProjectUnrestricted(Project var1);

    @NotNull
    public List<ImmutableChain> getPlansByProjectUnrestrictedWithConsistencyGuarantee(Project var1);

    @NotNull
    public Set<PlanKey> getBranchKeysOfChain(@NotNull PlanKey var1);

    @NotNull
    public Set<PlanBranchGist> getBranchGistsOfChain(@NotNull PlanKey var1);

    @NotNull
    public Set<PlanBranchGist> getBranchGistsOfChainWithConsistencyGuarantee(@NotNull PlanKey var1);

    @Nullable
    public ImmutableChain getMasterPlan(@NotNull PlanKey var1);

    public boolean isBranchOf(@NotNull PlanKey var1, @NotNull PlanKey var2);

    @Nullable
    public ImmutableJob getMasterOfJob(@NotNull PlanKey var1, @NotNull PlanKey var2);

    public Iterable<ImmutableChain> getPlansWithRepository(@NotNull PlanRepositoryIndex.Query var1);

    public Iterable<ImmutableChain> getPlansWithRepositoryWithConsistencyGuarantee(@NotNull PlanRepositoryIndex.Query var1);

    public Set<Project> getAllProjectsWithPlan();
}

