/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.cache.OptimisticLockingVersionMissesCounter;
import com.google.common.base.MoreObjects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import java.util.Optional;

@Internal
public class BambooCacheStats {
    private final CacheStats stats;
    private final long cacheSize;
    private final Optional<OptimisticLockingVersionMissesCounter> optimisticLockingVersionMisses;

    public BambooCacheStats(Cache<?, ?> cache) {
        this.cacheSize = cache.size();
        this.stats = cache.stats();
        this.optimisticLockingVersionMisses = Optional.empty();
    }

    public BambooCacheStats(Cache<?, ?> cache, OptimisticLockingVersionMissesCounter optimisticLockingVersionMissesCounter) {
        this.cacheSize = cache.size();
        this.stats = cache.stats();
        this.optimisticLockingVersionMisses = Optional.of(optimisticLockingVersionMissesCounter);
    }

    public CacheStats getStats() {
        return this.stats;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public long getOptimisticLockingVersionMissesAndReset() {
        return this.optimisticLockingVersionMisses.map(OptimisticLockingVersionMissesCounter::getAndReset).orElse(0L);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cacheSize", this.cacheSize).add("stats", (Object)this.stats).toString();
    }
}

