/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface PlanManager {
    @Nullable
    public PlanIdentifier getPlanIdentifierForPermissionCheckingByKey(@NotNull String var1);

    @Nullable
    public Plan getPlanById(long var1) throws IncorrectPlanTypeException;

    @Nullable
    public <T extends Plan> T getPlanById(long var1, Class<T> var3) throws IncorrectPlanTypeException;

    @Nullable
    public <T extends Plan> T getPlanByOid(BambooEntityOid var1, Class<T> var2) throws IncorrectPlanTypeException;

    @Nullable
    public Plan getPlanByKey(@NotNull PlanKey var1) throws IncorrectPlanTypeException;

    @Nullable
    public <T extends Plan> T getPlanByKey(@NotNull PlanKey var1, Class<T> var2) throws IncorrectPlanTypeException;

    @Nullable
    public <T extends Plan> T getPlanByKeyIfOfType(@NotNull PlanKey var1, @NotNull Class<T> var2);

    public List<TopLevelPlan> getAllPlansUnrestricted();

    @NotNull
    public <T extends Plan> List<T> getAllPlans(Class<T> var1);

    @NotNull
    public <T extends Plan> List<T> getAllPlans(Class<T> var1, int var2, int var3);

    @NotNull
    public List<Chain> getAllChainsAndJobsUnrestricted();

    @NotNull
    public List<TopLevelPlan> getPlansByProject(Project var1);

    @NotNull
    public <T extends Plan> List<T> getPlansByProject(Project var1, Class<T> var2);

    @NotNull
    public <T extends Plan> List<T> getAllPlansByProject(Project var1, Class<T> var2);

    @NotNull
    public <T extends Plan> Map<Project, Collection<T>> getProjectPlanMap(Class<T> var1, boolean var2);

    @NotNull
    public <T extends Plan> List<PlanIdentifier> getPlanIdentifiersForProject(@NotNull ProjectIdentifier var1, @NotNull Class<T> var2, boolean var3);

    public Set<ImmutableChain> getFavouritePlans(@NotNull User var1);

    @NotNull
    public Set<Long> getFavouritePlansIds(@NotNull User var1);

    @NotNull
    public Set<ImmutableChain> filterFavouritedPlans(@NotNull Collection<? extends ImmutableChain> var1, @NotNull User var2);

    public int getPlanCount();

    public <T extends Plan> int getPlanCount(Class<T> var1);

    public int getPlanCount(@NotNull ProjectIdentifier var1);

    public boolean isChainNameConflicting(@NotNull String var1, long var2, @NotNull String var4);

    public boolean isPlanKeyConflicting(@NotNull PlanKey var1);

    public boolean isPlanKeyConflicting(@NotNull PlanKey var1, long var2);

    @Deprecated
    @Nullable
    public <T extends Plan> T getPlanByPartialKeyAndName(@NotNull PlanKey var1, @NotNull String var2, Class<T> var3) throws IncorrectPlanTypeException;

    @Nullable
    public Class<? extends Plan> getPlanClass(@NotNull PlanKey var1);

    public boolean assertPlanPermission(@NotNull PlanIdentifier var1);

    public boolean isPlanCreationAllowed();

    public void savePlan(@NotNull Plan var1);

    public void savePlanWithSchedulesStopped(@NotNull Plan var1);

    public void setPlanSuspendedState(PlanKey var1, boolean var2);

    public void triggerConfigUpdatedEventsForPlansInProject(@NotNull Project var1);

    public void createPlan(Plan var1);

    public void deletePlan(@NotNull Plan var1);

    public void markPlansForDeletion(PlanKey var1);

    public void removeStages(@NotNull PlanKey var1, @NotNull Collection<Long> var2);

    @Deprecated
    @Nullable
    public Plan getPlanByKey(@NotNull String var1) throws IncorrectPlanTypeException;

    @Deprecated
    @Nullable
    public <T extends Plan> T getPlanByKey(@NotNull String var1, Class<T> var2) throws IncorrectPlanTypeException;

    public <T extends Plan> long getAllPlansMarkedForDeletionCount(Class<T> var1);
}

