/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.performance;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.performance.ActionType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@Internal
public class ActionIdentifier {
    private static final String KEY_SEPARATOR = ":";
    private final ActionType type;
    private final String name;

    public ActionIdentifier(@NotNull ActionType type, @NotNull String name) {
        this.type = type;
        this.name = name;
    }

    public static ActionIdentifier fromKey(@NotNull String key) {
        String[] chunks = key.split(KEY_SEPARATOR);
        if (chunks.length != 2) {
            throw new IllegalStateException("Invalid format of the key");
        }
        return new ActionIdentifier(ActionType.valueOf(chunks[0]), chunks[1]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionIdentifier)) {
            return false;
        }
        ActionIdentifier that = (ActionIdentifier)o;
        return this.type == that.type && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public String toString() {
        return this.getKey();
    }

    public String getKey() {
        return String.valueOf((Object)this.type) + KEY_SEPARATOR + this.name;
    }

    @NotNull
    public ActionType getType() {
        return this.type;
    }

    @NotNull
    public String getName() {
        return this.name;
    }
}

