/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jira.rest;

import com.atlassian.bamboo.jira.rest.Errors;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;

public class JiraRestResponse {
    public final int statusCode;
    @Nullable
    public final String statusMessage;
    @Nullable
    public final Errors errors;
    @Nullable
    public final String body;
    @Nullable
    public final JsonObject entity;

    public JiraRestResponse(String errorMessage) {
        this.errors = new Errors();
        this.errors.addError(errorMessage);
        this.statusCode = Integer.MAX_VALUE;
        this.statusMessage = null;
        this.body = null;
        this.entity = null;
    }

    public JiraRestResponse(int statusCode, String statusMessage, Errors errors, String body, JsonObject entity) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.errors = errors;
        this.body = body;
        this.entity = entity;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean hasErrors() {
        if (this.errors != null) {
            return !this.errors.errorMessages.isEmpty() || !this.errors.errors.isEmpty();
        }
        return false;
    }

    public static class JiraRestResponseBuilder {
        private final int statusCode;
        private final String statusMessage;
        private Errors errors;
        private String body;
        private JsonObject entity;

        public JiraRestResponseBuilder(int statusCode, String statusMessage) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
        }

        public JiraRestResponseBuilder errors(Errors errors) {
            this.errors = errors;
            return this;
        }

        public JiraRestResponseBuilder body(String body) {
            this.body = body;
            return this;
        }

        public JiraRestResponseBuilder entity(JsonObject entity) {
            this.entity = entity;
            return this;
        }

        @Deprecated
        public JiraRestResponseBuilder entity(JSONObject entity) {
            this.entity = JsonParser.parseString((String)entity.toString()).getAsJsonObject();
            return this;
        }

        public JiraRestResponseBuilder addError(String s) {
            if (this.errors == null) {
                this.errors = new Errors();
            }
            this.errors.addError(s);
            return this;
        }

        public JiraRestResponse build() {
            return new JiraRestResponse(this.statusCode, this.statusMessage, this.errors, this.body, this.entity);
        }
    }
}

