/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.expiry;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryConfig;
import com.atlassian.bamboo.utils.Pair;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Period;

@Internal
class DeploymentExpiryConfigResolver {
    DeploymentExpiryConfigResolver() {
    }

    public DeploymentExpiryConfig resolve(@NotNull DeploymentExpiryConfig deploymentExpiryConfig) {
        if (StringUtils.isBlank((CharSequence)deploymentExpiryConfig.getPeriodString())) {
            return deploymentExpiryConfig;
        }
        Period jodaPeriod = Period.parse((String)deploymentExpiryConfig.getPeriodString());
        Pair<String, Integer> periodAsPair = this.jodaPeriodToExpiryConfig(jodaPeriod);
        return new DeploymentExpiryConfig(deploymentExpiryConfig.isExpiryEnabled(), deploymentExpiryConfig.getExpiryTypes(), periodAsPair.getFirst(), periodAsPair.getSecond(), deploymentExpiryConfig.getDeploymentsToKeep(), deploymentExpiryConfig.getAnyDeploymentsToKeep(), deploymentExpiryConfig.getMaxIgnoredLogSize());
    }

    private Pair<String, Integer> jodaPeriodToExpiryConfig(Period jodaPeriod) {
        if (jodaPeriod.getMonths() != 0) {
            return Pair.make("months", jodaPeriod.getMonths());
        }
        if (jodaPeriod.getWeeks() != 0) {
            return Pair.make("weeks", jodaPeriod.getWeeks());
        }
        return Pair.make("days", jodaPeriod.getDays());
    }
}

