/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.util.BambooConstantUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class RepositorySettings
implements Serializable {
    public static final int DEFAULT_BUILD_CONTEXT_COMMIT_LIMIT = BambooConstantUtils.preventInlining(100);
    public static final String DEFAULT_AUTHOR_NAME = BambooConstantUtils.preventInlining("Atlassian Bamboo");
    public static final String DEFAULT_AUTHOR_EMAIL = BambooConstantUtils.preventInlining("bamboo@example.com");
    private String authorName;
    private String authorEmail;
    private String integrationCommitMessage;
    private String subversionWorkingCopyFormat;
    private boolean useNtlmAuth;

    @NotNull
    public String getAuthorName() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.authorName, (CharSequence)DEFAULT_AUTHOR_NAME);
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public String getAuthorEmail() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.authorEmail, (CharSequence)DEFAULT_AUTHOR_EMAIL);
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public String getIntegrationCommitMessage() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.integrationCommitMessage, (CharSequence)"[bamboo] Automated branch merge");
    }

    public void setIntegrationCommitMessage(String integrationCommitMessage) {
        this.integrationCommitMessage = integrationCommitMessage;
    }

    @NotNull
    public String getSubversionWorkingCopyFormat() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.subversionWorkingCopyFormat, (CharSequence)SystemProperty.SVN_WC_FORMAT.getValue("1.8"));
    }

    public void setSubversionWorkingCopyFormat(String subversionWorkspaceFormat) {
        this.subversionWorkingCopyFormat = subversionWorkspaceFormat;
    }

    public boolean isUseNtlmAuth() {
        return this.useNtlmAuth;
    }

    public void setUseNtlmAuth(boolean useNtlmAuth) {
        this.useNtlmAuth = useNtlmAuth;
    }

    public int getBuildContextCommitLimit() {
        return DEFAULT_BUILD_CONTEXT_COMMIT_LIMIT;
    }
}

