/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.cluster.tape;

import com.atlassian.bamboo.cluster.BambooClusterSettings;
import com.atlassian.bamboo.cluster.event.CrossNodesEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PerNodeLocalQueue {
    public static final int NUMBER_OF_PHYSICAL_QUEUES_PER_NODE = (int)BambooClusterSettings.NUMBER_OF_PHYSICAL_QUEUES_UNDER_PER_NODE_QUEUE.getTypedValue();

    public void close();

    public boolean isClosed();

    @NotNull
    public String name();

    @NotNull
    public QueueId id();

    public boolean add(CrossNodesEvent var1) throws IllegalStateException;

    @Nullable
    public CrossNodesEvent peek() throws IllegalStateException;

    public void remove() throws NoSuchElementException, IllegalStateException;

    @NotNull
    public Optional<Path> getQueueFilePath();

    public boolean hasPermission();

    @Nullable
    public Long usableSpaceInBytes();

    public int size();

    public void backupQueue(String var1) throws IOException;

    public static int nodeQueueNumberForCurrentThread() {
        return PerNodeLocalQueue.nodeQueueNumber(Thread.currentThread().getId());
    }

    public static int nodeQueueNumber(long threadId) {
        return (int)(threadId % (long)NUMBER_OF_PHYSICAL_QUEUES_PER_NODE);
    }

    public static class QueueId {
        private static final String QUEUE_ID_PATTERN = "queue_%s_%d_%s";
        public final String nodeId;
        public final int nodeQueueNumber;

        private QueueId(String nodeId, int nodeQueueNumber) {
            this.nodeId = nodeId;
            this.nodeQueueNumber = nodeQueueNumber;
        }

        public static QueueId create(String nodeId, int nodeQueueNumber) {
            return new QueueId(nodeId, nodeQueueNumber);
        }

        @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"})
        public String toString() {
            String hashedNodeId = DigestUtils.md5Hex((String)this.nodeId);
            String cleanNodeId = this.nodeId.replaceAll("\\W+", "");
            return String.format(QUEUE_ID_PATTERN, cleanNodeId, this.nodeQueueNumber, hashedNodeId);
        }

        public String filename() {
            return this.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueueId queueId = (QueueId)o;
            return this.nodeQueueNumber == queueId.nodeQueueNumber && Objects.equals(this.nodeId, queueId.nodeId);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.nodeQueueNumber);
        }
    }
}

