/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.cluster;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.utils.SystemProperty;
import java.util.Optional;

@Internal
public interface BambooClusterSettings {
    public static final SystemProperty.BooleanSystemProperty NODE_ALIVE_WATCHDOG_ENABLED = SystemProperty.NODE_ALIVE_WATCHDOG_ENABLED;
    public static final SystemProperty.IntegerSystemProperty NODE_ALIVE_WATCHDOG_INTERVAL_IN_SECONDS = SystemProperty.NODE_ALIVE_WATCHDOG_INTERVAL_IN_SECONDS;
    public static final SystemProperty.IntegerSystemProperty CLUSTER_HEARTBEAT_ALIVE_TIMEOUT_IN_SECONDS = SystemProperty.CLUSTER_HEARTBEAT_ALIVE_TIMEOUT_IN_SECONDS;
    public static final SystemProperty.IntegerSystemProperty CLUSTER_HEARTBEAT_JOB_INTERVAL_IN_SECONDS = SystemProperty.CLUSTER_HEARTBEAT_JOB_INTERVAL_IN_SECONDS;
    public static final SystemProperty OPTIMISTIC_LOCKING_MODE = SystemProperty.OPTIMISTIC_LOCKING_MODE;
    public static final SystemProperty.IntegerSystemProperty PRIMARY_CLUSTER_LOCK_TIMEOUT_SECONDS = SystemProperty.PRIMARY_CLUSTER_LOCK_TIMEOUT_SECONDS;
    public static final SystemProperty.IntegerSystemProperty GRPC_SERVER_THREADS_NUMBER = SystemProperty.GRPC_SERVER_THREADS_NUMBER;
    public static final SystemProperty.IntegerSystemProperty CROSS_NODES_EVENTS_GRPC_CLIENT_THREADS_NUMBER = SystemProperty.CROSS_NODES_EVENTS_GRPC_CLIENT_THREADS_NUMBER;
    public static final SystemProperty.IntegerSystemProperty PEER_TO_PEER_GRPC_CLIENT_THREADS_NUMBER = SystemProperty.PEER_TO_PEER_GRPC_CLIENT_THREADS_NUMBER;
    public static final SystemProperty.IntegerSystemProperty PER_NODE_QUEUE_DISPATCHERS_THREADS_NUMBER = SystemProperty.PER_NODE_QUEUE_DISPATCHERS_THREADS_NUMBER;
    public static final SystemProperty.IntegerSystemProperty NUMBER_OF_PHYSICAL_QUEUES_UNDER_PER_NODE_QUEUE = SystemProperty.NUMBER_OF_PHYSICAL_QUEUES_UNDER_PER_NODE_QUEUE;
    public static final SystemProperty.IntegerSystemProperty PER_NODE_PHYSICAL_QUEUE_MAX_SIZE = SystemProperty.PER_NODE_PHYSICAL_QUEUE_MAX_SIZE;
    public static final SystemProperty.IntegerSystemProperty PER_NODE_PHYSICAL_QUEUE_MAX_USED_BYTES = SystemProperty.PER_NODE_PHYSICAL_QUEUE_MAX_USED_BYTES;
    public static final SystemProperty.IntegerSystemProperty BAMBOO_CLUSTER_INFO_CACHE_TTL_SECONDS = SystemProperty.BAMBOO_CLUSTER_INFO_CACHE_TTL_SECONDS;
    public static final long PER_NODE_QUEUE_STATS_LOGGING_INTERVAL_MINUTES = Optional.of(SystemProperty.PER_NODE_QUEUE_STATS_LOGGING_INTERVAL_MINUTES.getTypedValue()).filter(v -> v > 0L).orElse(10L);
    public static final SystemProperty.BooleanSystemProperty CLUSTER_CONNECT_SECONDARY_ONLY_IF_GRPC_COMMUNICATION_IS_WORKING = SystemProperty.CLUSTER_CONNECT_SECONDARY_ONLY_IF_GRPC_COMMUNICATION_IS_WORKING;

    public boolean isOptimisticLockingEnabled();

    public boolean isReadyToReceiveCrossNodesEvents();

    public void setReadyToReceiveCrossNodesEvents(boolean var1);
}

