/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.expiry;

import com.atlassian.bamboo.build.expiry.BuildExpiryType;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.Serializable;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildExpiryConfig
implements Serializable {
    public static final String DAYS = "days";
    public static final String WEEKS = "weeks";
    public static final String MONTHS = "months";
    public static final String BUILD_LOG_EXPIRY = "buildlog";
    public static final String ARTIFACT_EXPIRY = "artifact";
    public static final String RESULTS_EXPIRY = "result";
    public static final String NOTHING_EXPIRY = "nothing";
    public static final String DEFAULT_CRON_EXPRESSION = "0 0 0 ? * *";
    public static final long REMOVE_ALL_LOGS = -1L;
    private String myPeriod;
    private int myDuration;
    private int buildsToKeep;
    private int maximumBuildsToKeep;
    private long maxIgnoredLogSize = -1L;
    private boolean expiryTypeNothing;
    private boolean expiryTypeResult;
    private boolean expiryTypeArtifact;
    private boolean expiryTypeBuildLog;
    private String labelsToKeep;
    private String cronExpression;
    private transient ResettableLazyReference<List<String>> labelsList = this.getLabelsListLazyReference();
    private boolean enabled = false;

    public BuildExpiryConfig() {
    }

    public BuildExpiryConfig(int buildsToKeep) {
        this.buildsToKeep = buildsToKeep;
    }

    public BuildExpiryConfig(int duration, String period) {
        this.myPeriod = period;
        this.myDuration = duration;
    }

    public BuildExpiryConfig(int duration, String period, int buildsToKeep) {
        this(duration, period);
        this.buildsToKeep = buildsToKeep;
    }

    public BuildExpiryConfig(Collection<BuildExpiryType> expiryType, int duration, String period, int buildsToKeep) {
        this(duration, period, buildsToKeep);
        this.setBuildExpiryTypes(expiryType);
    }

    public BuildExpiryConfig(Collection<BuildExpiryType> expiryType, int duration, String period, int buildsToKeep, String labelsToKeep) {
        this(expiryType, duration, period, buildsToKeep);
        this.labelsToKeep = labelsToKeep;
    }

    public boolean isExpiryTypeNothing() {
        return this.expiryTypeNothing;
    }

    public void setExpiryTypeNothing(boolean expiryTypeNothing) {
        this.expiryTypeNothing = expiryTypeNothing;
        if (expiryTypeNothing) {
            this.expiryTypeResult = false;
            this.expiryTypeArtifact = false;
            this.expiryTypeBuildLog = false;
            this.setDuration(0);
            this.setBuildsToKeep(0);
        }
    }

    public boolean isExpiryTypeResult() {
        return this.expiryTypeResult;
    }

    public void setExpiryTypeResult(boolean expiryTypeResult) {
        this.expiryTypeResult = expiryTypeResult;
        if (expiryTypeResult) {
            this.expiryTypeNothing = false;
            this.expiryTypeArtifact = true;
            this.expiryTypeBuildLog = true;
        }
    }

    public boolean isExpiryTypeArtifact() {
        return this.expiryTypeArtifact;
    }

    public void setExpiryTypeArtifact(boolean expiryTypeArtifact) {
        this.expiryTypeArtifact = expiryTypeArtifact;
    }

    public boolean isExpiryTypeBuildLog() {
        return this.expiryTypeBuildLog;
    }

    public void setExpiryTypeBuildLog(boolean expiryTypeBuildLog) {
        this.expiryTypeBuildLog = expiryTypeBuildLog;
    }

    @NotNull
    public Collection<BuildExpiryType> getBuildExpiryTypes() {
        ArrayList<BuildExpiryType> expiryTypes = new ArrayList<BuildExpiryType>();
        if (this.expiryTypeNothing) {
            expiryTypes.add(BuildExpiryType.NOTHING_BUILD_EXPIRY_TYPE);
        }
        if (this.expiryTypeResult) {
            expiryTypes.add(BuildExpiryType.RESULTS_BUILD_EXPIRY_TYPE);
        }
        if (this.expiryTypeArtifact) {
            expiryTypes.add(BuildExpiryType.ARTIFACT_BUILD_EXPIRY_TYPE);
        }
        if (this.expiryTypeBuildLog) {
            expiryTypes.add(BuildExpiryType.BUILD_LOG_EXPIRY_TYPE);
        }
        return expiryTypes;
    }

    public void setBuildExpiryTypes(Collection<BuildExpiryType> expiryTypes) {
        for (BuildExpiryType expiryType : expiryTypes) {
            if (BuildExpiryType.ARTIFACT_BUILD_EXPIRY_TYPE.equals(expiryType)) {
                this.setExpiryTypeArtifact(true);
            }
            if (BuildExpiryType.BUILD_LOG_EXPIRY_TYPE.equals(expiryType)) {
                this.setExpiryTypeBuildLog(true);
            }
            if (BuildExpiryType.RESULTS_BUILD_EXPIRY_TYPE.equals(expiryType)) {
                this.setExpiryTypeResult(true);
            }
            if (!BuildExpiryType.NOTHING_BUILD_EXPIRY_TYPE.equals(expiryType)) continue;
            this.setExpiryTypeNothing(true);
        }
    }

    public String getPeriod() {
        return this.myPeriod;
    }

    public int getDuration() {
        return this.myDuration;
    }

    public int getBuildsToKeep() {
        return this.buildsToKeep;
    }

    public void setBuildsToKeep(int buildsToKeep) {
        this.buildsToKeep = buildsToKeep;
    }

    public void setPeriod(String myPeriod) {
        this.myPeriod = myPeriod;
    }

    public void setDuration(int myDuration) {
        this.myDuration = myDuration;
    }

    public boolean isExpireByDate() {
        return this.getDuration() > 0;
    }

    public boolean isExpireByBuild() {
        return this.getBuildsToKeep() > 0;
    }

    @Deprecated
    @Nullable
    public String getLabelsToKeep() {
        return StringUtils.lowerCase((String)this.labelsToKeep);
    }

    public void setLabelsToKeep(String labelsToKeep) {
        this.labelsToKeep = StringUtils.lowerCase((String)labelsToKeep);
        this.labelsList.reset();
    }

    public int getMaximumBuildsToKeep() {
        return this.maximumBuildsToKeep;
    }

    public void setMaximumBuildsToKeep(int maximumBuildsToKeep) {
        this.maximumBuildsToKeep = maximumBuildsToKeep;
    }

    public boolean hasMaximumBuildsToKeep() {
        return this.getMaximumBuildsToKeep() > 0;
    }

    @NotNull
    public String getCronExpression() {
        if (this.cronExpression != null) {
            return this.cronExpression;
        }
        return DEFAULT_CRON_EXPRESSION;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @NotNull
    public List<String> getLabelsList() {
        return (List)this.labelsList.get();
    }

    public Period getExpiryPeriod() {
        return BuildExpiryConfig.toPeriod(this.myDuration, this.myPeriod);
    }

    public long getMaxIgnoredLogSize() {
        return this.maxIgnoredLogSize;
    }

    public void setMaxIgnoredLogSize(long maxIgnoredLogSize) {
        this.maxIgnoredLogSize = maxIgnoredLogSize;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public static Period toPeriod(int myDuration, String myPeriod) {
        if (DAYS.equals(myPeriod)) {
            return Period.ofDays(myDuration);
        }
        if (WEEKS.equals(myPeriod)) {
            return Period.ofWeeks(myDuration);
        }
        if (MONTHS.equals(myPeriod)) {
            return Period.ofMonths(myDuration);
        }
        throw new IllegalStateException("\"" + myPeriod + "\" is an unknown period");
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("enabled", this.enabled).append("buildsToKeep", this.buildsToKeep).append("maximumBuildsToKeep", this.maximumBuildsToKeep).append("period", (Object)(this.myDuration + " " + this.myPeriod)).append("maxIgnoredLogSize", this.maxIgnoredLogSize).append("cronExpression", (Object)this.cronExpression).append("expiryTypes", this.getBuildExpiryTypes()).append("labelsToKeep", this.getLabelsList());
        return toStringBuilder.toString();
    }

    private ResettableLazyReference<List<String>> getLabelsListLazyReference() {
        return new ResettableLazyReference<List<String>>(){

            protected List<String> create() throws Exception {
                if (BuildExpiryConfig.this.labelsToKeep == null) {
                    return List.of();
                }
                return List.copyOf(Arrays.stream(StringUtils.split((String)StringUtils.lowerCase((String)BuildExpiryConfig.this.labelsToKeep), (String)" ,")).toList());
            }
        };
    }

    protected Object readResolve() {
        this.labelsList = this.getLabelsListLazyReference();
        return this;
    }
}

