/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.ephemeral.result;

import com.atlassian.bamboo.agent.ephemeral.result.CommonAgentMaintenanceResult;
import com.google.gson.Gson;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TestConnectionResult
extends CommonAgentMaintenanceResult {
    private static final Logger log = Logger.getLogger(TestConnectionResult.class);
    private static final String GIT_VERSION = "gitVersion";
    private String clientVersion;
    private String serverVersion;
    private int exitCode;

    public TestConnectionResult(String rawOutput, String rawErrorOutput, int exitCode) {
        super(rawOutput, rawErrorOutput);
        this.parseVersions();
        this.exitCode = exitCode;
    }

    private void parseVersions() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.rawOutput})) {
            Gson gson = new Gson();
            try {
                Map config = (Map)gson.fromJson(this.rawOutput, Map.class);
                this.clientVersion = config.getOrDefault("clientVersion", Map.of(GIT_VERSION, "unknown")).get(GIT_VERSION).toString();
                this.serverVersion = config.getOrDefault("serverVersion", Map.of(GIT_VERSION, "unknown")).get(GIT_VERSION).toString();
            }
            catch (Exception e) {
                log.debug(null, (Throwable)e);
            }
        }
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

