/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.ephemeral.result;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bamboo.agent.ephemeral.result.CommonAgentMaintenanceResult;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetPodsJsonResult
extends CommonAgentMaintenanceResult {
    public static final String BAMBOO_AGENT_CONTAINER_NAME = "bamboo-ephemeral-agent";

    public GetPodsJsonResult(String rawOutput, String rawErrorOutput) {
        super(rawOutput, rawErrorOutput);
    }

    @NotNull
    public List<String> getPodsWithTerminatedAgent() {
        return this.getPodsWithConstrainedAgent(this::isAgentTerminated);
    }

    @NotNull
    public List<String> getPodsWithRunningAgent() {
        return this.getPodsWithConstrainedAgent(this::isAgentRunning);
    }

    @NotNull
    private List<String> getPodsWithConstrainedAgent(Predicate<JsonObject> agentFilter) {
        Gson gson = new Gson();
        JsonObject podsResponse = (JsonObject)gson.fromJson(this.rawOutput, JsonObject.class);
        Optional podsList = Optional.ofNullable(podsResponse).flatMap(obj -> Optional.ofNullable(obj.getAsJsonArray("items")));
        if (podsList.isPresent()) {
            Spliterator pods = ((JsonArray)podsList.get()).spliterator();
            return StreamSupport.stream(pods, false).map(JsonElement::getAsJsonObject).filter(Objects::nonNull).filter(p -> !this.isPodMarkedForTermination((JsonObject)p)).filter(agentFilter).map(this::getPodName).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @VisibleForTesting
    boolean isPodMarkedForTermination(JsonObject pod) {
        return Optional.ofNullable(pod).map(p -> p.getAsJsonObject("metadata")).map(metadata -> metadata.get("deletionTimestamp")).map(p -> !p.isJsonNull()).orElse(false);
    }

    @VisibleForTesting
    boolean isAgentTerminated(JsonObject pod) {
        return this.isAgentInState(pod, "terminated");
    }

    @VisibleForTesting
    boolean isAgentRunning(JsonObject pod) {
        return this.isAgentInState(pod, "running");
    }

    private boolean isAgentInState(JsonObject pod, String state) {
        return Optional.ofNullable(pod.getAsJsonObject("status")).map(podStatus -> podStatus.getAsJsonArray("containerStatuses")).map(containerStatuses -> StreamSupport.stream(containerStatuses.spliterator(), false).map(JsonElement::getAsJsonObject).filter(Objects::nonNull).filter(status -> Objects.nonNull(status.get("name"))).filter(status -> status.get("name").getAsString().equals(BAMBOO_AGENT_CONTAINER_NAME)).anyMatch(status -> Optional.ofNullable(status.getAsJsonObject("state")).map(s -> s.has(state)).orElse(false))).orElse(false);
    }

    @Nullable
    private String getPodName(JsonObject pod) {
        return Optional.ofNullable(pod.getAsJsonObject("metadata")).flatMap(metadata -> Optional.ofNullable(metadata.get("name").getAsString())).orElse(null);
    }
}

