/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.ephemeral;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PodsDto {
    @NotNull
    private final List<PodDto> items;

    public PodsDto() {
        this.items = new ArrayList<PodDto>();
    }

    public PodsDto(@NotNull List<PodDto> items) {
        this.items = items;
    }

    @NotNull
    public List<PodDto> getItems() {
        return this.items;
    }

    public static class PodContainerStatus {
        private String name;
        private boolean ready;
        private boolean started;

        public String getName() {
            return this.name;
        }

        public boolean isReady() {
            return this.ready;
        }

        public boolean isStarted() {
            return this.started;
        }
    }

    public static class PodStatus {
        @Nullable
        private final String podIP;
        @Nullable
        private final String phase;
        private final List<PodContainerStatus> containerStatuses = new ArrayList<PodContainerStatus>();

        private PodStatus() {
            this.podIP = null;
            this.phase = null;
        }

        @Nullable
        public String getPodIP() {
            return this.podIP;
        }

        @Nullable
        public String getPhase() {
            return this.phase;
        }

        @Nullable
        public List<PodContainerStatus> getContainerStatuses() {
            return this.containerStatuses;
        }
    }

    public static class PodSpec {
        @Nullable
        private final List<PodContainer> containers = new ArrayList<PodContainer>();
        @Nullable
        private final String hostname;

        public PodSpec() {
            this.hostname = null;
        }

        @Nullable
        public List<PodContainer> getContainers() {
            return this.containers;
        }

        @Nullable
        public String getHostname() {
            return this.hostname;
        }
    }

    public static class PodVariable {
        @Nullable
        private final String name;
        @Nullable
        private final String value;

        private PodVariable() {
            this.name = null;
            this.value = null;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }
    }

    public static class PodContainer {
        @Nullable
        private final List<PodVariable> env = new ArrayList<PodVariable>();
        @Nullable
        private final String image;
        private final String name;

        private PodContainer() {
            this.image = null;
            this.name = null;
        }

        @Nullable
        public List<PodVariable> getEnv() {
            return this.env;
        }

        @Nullable
        public String getImage() {
            return this.image;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class PodMetadata {
        @Nullable
        private final String name;
        @Nullable
        private final Date creationTimestamp = null;

        private PodMetadata() {
            this.name = null;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public Date getCreationDate() {
            return this.creationTimestamp;
        }
    }

    public static class PodDto {
        @NotNull
        private final PodMetadata metadata = null;
        @NotNull
        private final PodSpec spec = null;
        @NotNull
        private final PodStatus status = null;

        @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"})
        private PodDto() {
        }

        @NotNull
        public PodMetadata getMetadata() {
            return this.metadata;
        }

        @NotNull
        public PodSpec getSpec() {
            return this.spec;
        }

        @NotNull
        public PodStatus getStatus() {
            return this.status;
        }
    }
}

