/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.ephemeral;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PodPhase {
    PENDING("Pending", true, "queued-build"),
    RUNNING("Running", true, ""),
    SUCCEEDED("Succeeded", false, "agent-offline"),
    FAILED("Failed", false, "agent-offline"),
    UNDEFINED("Undefined", false, "");

    private final String value;
    private final boolean isActive;
    private final String icon;
    public static final List<PodPhase> ACTIVE_PHASES;

    private PodPhase(String value, boolean isActive, String icon) {
        this.value = value;
        this.isActive = isActive;
        this.icon = icon;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getIcon() {
        return this.icon;
    }

    public static boolean isWorking(PodPhase podPhase) {
        return podPhase == PENDING || podPhase == RUNNING;
    }

    @NotNull
    public static PodPhase fromValue(@Nullable String value) {
        if (value == null) {
            return UNDEFINED;
        }
        return Arrays.stream(PodPhase.values()).filter(type -> Objects.equals(type.getValue(), value)).findFirst().orElse(UNDEFINED);
    }

    static {
        ACTIVE_PHASES = List.copyOf(Arrays.stream(PodPhase.values()).filter(PodPhase::isActive).collect(Collectors.toList()));
    }
}

