/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import org.jetbrains.annotations.NotNull;

public final class ElasticImageFilesCapabilitiesHelper {
    private ElasticImageFilesCapabilitiesHelper() {
    }

    public static boolean supportsBdmVolumeCreation(@NotNull ElasticImageConfiguration elasticImageConfiguration) {
        if (elasticImageConfiguration.getRootDeviceType() == AwsSupportConstants.RootDeviceType.S3) {
            return false;
        }
        return ElasticImageFilesCapabilitiesHelper.supportsEbsDeviceMounting(elasticImageConfiguration);
    }

    public static boolean supportsEbsDeviceMounting(ElasticImageConfiguration elasticImageConfiguration) {
        if (elasticImageConfiguration.getPlatform().isWindows() || elasticImageConfiguration.getImageFilesVersion() != null) {
            return true;
        }
        return !elasticImageConfiguration.isLegacyEbsHandlingEnabled();
    }
}

