/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class FileHashDescriptor {
    private final long checksum;
    private final String filename;

    public FileHashDescriptor(String filename, long checksum) {
        this.filename = filename;
        this.checksum = checksum;
    }

    public static Set<FileHashDescriptor> getFileHashDescriptors(@NotNull Map<String, String> fileToCrcHashMap) {
        return fileToCrcHashMap.entrySet().stream().map(entry -> new FileHashDescriptor((String)entry.getKey(), Long.parseLong((String)entry.getValue(), 16))).collect(Collectors.toSet());
    }

    public String getFilename() {
        return this.filename;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileHashDescriptor that = (FileHashDescriptor)o;
        if (this.checksum != that.checksum) {
            return false;
        }
        return this.filename.equals(that.filename);
    }

    public int hashCode() {
        int result = (int)(this.checksum ^ this.checksum >>> 32);
        result = 31 * result + this.filename.hashCode();
        return result;
    }

    public String toString() {
        return this.filename + "|" + Long.toHexString(this.checksum);
    }
}

