/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.accesstoken;

import com.atlassian.bamboo.accesstoken.AccessTokenPermission;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateAccessTokenRequest {
    private final String name;
    private final String userName;
    private final Set<AccessTokenPermission> permissions;
    private final Integer daysUntilExpiry;

    public CreateAccessTokenRequest(@NotNull String name, @NotNull String userName, @NotNull Iterable<AccessTokenPermission> permissions, @Nullable Integer daysUntilExpiry) {
        this.name = name;
        this.userName = userName;
        this.permissions = StreamSupport.stream(permissions.spliterator(), false).collect(Collectors.toUnmodifiableSet());
        this.daysUntilExpiry = daysUntilExpiry;
    }

    public CreateAccessTokenRequest(String name, String userName, Iterable<AccessTokenPermission> permissions) {
        this(name, userName, permissions, null);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getUserName() {
        return this.userName;
    }

    @NotNull
    public Set<AccessTokenPermission> getPermissions() {
        return this.permissions;
    }

    @Nullable
    public Integer getDaysUntilExpiry() {
        return this.daysUntilExpiry;
    }
}

