/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.util.BambooSpringUtils;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.NameProvider;
import com.atlassian.bamboo.utils.predicates.BuildAgentPredicates;
import com.atlassian.bamboo.v2.build.agent.AgentIdleStatus;
import com.atlassian.bamboo.v2.build.agent.AgentStatus;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.BuildAgentImpl;
import com.atlassian.bamboo.v2.build.agent.DefaultBuildAgent;
import com.atlassian.bamboo.v2.build.agent.ExecutableBuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgentImpl;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class AgentStateCache {
    @NotNull
    @GuardedBy(value="lock")
    private final Map<Long, LocalBuildAgent> localAgents;
    @NotNull
    @GuardedBy(value="lock")
    private final Map<Long, BuildAgent> remoteAgents;
    @NotNull
    @GuardedBy(value="lock")
    private final Map<Long, BuildAgent> onlineElasticAgents;
    @NotNull
    @GuardedBy(value="lock")
    private final Map<Long, BuildAgent> allAgents;
    private static final Logger log = LogManager.getLogger();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public AgentStateCache() {
        this.localAgents = CopyOnWriteMap.newLinkedMap();
        this.remoteAgents = CopyOnWriteMap.newLinkedMap();
        this.onlineElasticAgents = CopyOnWriteMap.newLinkedMap();
        this.allAgents = CopyOnWriteMap.newLinkedMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseAgents(@NotNull Set<LocalBuildAgent> localAgents, @NotNull Set<BuildAgent> remoteAgents) {
        StopWatch stopWatch = StopWatch.createStarted();
        log.debug("Initializing Agent Cache");
        HashMap<Long, LocalBuildAgent> localAgentsToAdd = new HashMap<Long, LocalBuildAgent>();
        for (LocalBuildAgent localBuildAgent : localAgents) {
            localAgentsToAdd.put(localBuildAgent.getId(), localBuildAgent);
        }
        HashMap<Long, BuildAgent> remoteAgentsToAdd = new HashMap<Long, BuildAgent>();
        for (BuildAgent agent : remoteAgents) {
            remoteAgentsToAdd.put(agent.getId(), agent);
        }
        Map map = remoteAgents.stream().filter(buildAgent -> buildAgent.getDefinition() instanceof ElasticAgentDefinition).collect(Collectors.toMap(BuildAgent::getId, UnaryOperator.identity()));
        HashMap<Long, LocalBuildAgent> allAgents = new HashMap<Long, LocalBuildAgent>(remoteAgentsToAdd);
        allAgents.putAll(localAgentsToAdd);
        this.lock.writeLock().lock();
        try {
            this.localAgents.clear();
            this.remoteAgents.clear();
            this.allAgents.clear();
            this.onlineElasticAgents.clear();
            this.localAgents.putAll(localAgentsToAdd);
            this.remoteAgents.putAll(remoteAgentsToAdd);
            this.onlineElasticAgents.putAll(map);
            this.allAgents.putAll(allAgents);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        log.debug("Agent state cache initialized in " + stopWatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public BuildAgent updateAgentInCache(PipelineDefinition definition) {
        this.lock.readLock().lock();
        try {
            BuildAgent agent = this.allAgents.get(definition.getId());
            if (agent != null) {
                agent.setDefinition(definition);
                BuildAgent buildAgent = agent;
                return buildAgent;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            BuildAgent buildAgent = this.updateAgentInCacheInternal(definition);
            return buildAgent;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private BuildAgent updateAgentInCacheInternal(PipelineDefinition definition) {
        final AtomicReference buildAgentRef = new AtomicReference();
        definition.accept(new PipelineDefinitionVisitor(){

            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                BuildAgentImpl buildAgent = new BuildAgentImpl((PipelineDefinition)pipelineDefinition, (AgentStatus)AgentIdleStatus.getInstance());
                buildAgent.setLastUpdated(new Date());
                AgentStateCache.this.remoteAgents.put(pipelineDefinition.getId(), buildAgent);
                AgentStateCache.this.onlineElasticAgents.put(pipelineDefinition.getId(), buildAgent);
                AgentStateCache.this.allAgents.put(pipelineDefinition.getId(), buildAgent);
                buildAgentRef.set(buildAgent);
            }

            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                DefaultBuildAgent executableBuildAgent = new DefaultBuildAgent(pipelineDefinition.getId(), pipelineDefinition.getName(), pipelineDefinition.getDescription());
                BambooSpringUtils.autowireComponent((Object)executableBuildAgent);
                LocalBuildAgentImpl buildAgent = new LocalBuildAgentImpl(pipelineDefinition, (ExecutableBuildAgent)executableBuildAgent);
                executableBuildAgent.start();
                AgentStateCache.this.localAgents.put(pipelineDefinition.getId(), buildAgent);
                AgentStateCache.this.allAgents.put(pipelineDefinition.getId(), buildAgent);
                buildAgentRef.set(buildAgent);
            }

            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                BuildAgentImpl buildAgent = new BuildAgentImpl((PipelineDefinition)pipelineDefinition, (AgentStatus)AgentIdleStatus.getInstance());
                buildAgent.setLastUpdated(new Date());
                AgentStateCache.this.remoteAgents.put(pipelineDefinition.getId(), buildAgent);
                AgentStateCache.this.allAgents.put(pipelineDefinition.getId(), buildAgent);
                buildAgentRef.set(buildAgent);
            }
        });
        return (BuildAgent)buildAgentRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(@NotNull BuildAgent agent) {
        long id = agent.getId();
        this.lock.writeLock().lock();
        try {
            this.localAgents.remove(id);
            this.remoteAgents.remove(id);
            this.allAgents.remove(id);
            this.onlineElasticAgents.remove(id);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<LocalBuildAgent> getAllLocalAgents() {
        return AgentStateCache.getOrdering().sortedCopy(this.localAgents.values());
    }

    public List<BuildAgent> getOnlineElasticAgents() {
        return AgentStateCache.getOrdering().sortedCopy(this.onlineElasticAgents.values());
    }

    public List<BuildAgent> getAllRemoteAgents(boolean onlineOnly) {
        Collection<BuildAgent> remoteAgents = this.remoteAgents.values();
        if (!onlineOnly) {
            return AgentStateCache.getOrdering().sortedCopy(remoteAgents);
        }
        return AgentStateCache.getOrdering().sortedCopy(Iterables.filter(remoteAgents, BuildAgentPredicates::isActive));
    }

    public List<BuildAgent> getAllAgents() {
        return new ArrayList<BuildAgent>(this.allAgents.values());
    }

    public List<BuildAgent> getNonElasticAgents() {
        this.lock.readLock().lock();
        try {
            ArrayList<BuildAgent> nonElasticRemote = new ArrayList<BuildAgent>(this.remoteAgents.values());
            nonElasticRemote.removeAll(this.onlineElasticAgents.values());
            List list = AgentStateCache.getOrdering().sortedCopy(Iterables.concat(this.localAgents.values(), nonElasticRemote));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<BuildAgent> getBusyBuildAgents() {
        return AgentStateCache.getOrdering().sortedCopy(Iterables.filter(this.allAgents.values(), BuildAgentPredicates::isBusy));
    }

    public Collection<BuildAgent> getActiveAndEnabledAgents() {
        return AgentStateCache.getOrdering().sortedCopy(Iterables.filter(this.allAgents.values(), BuildAgentPredicates::isActiveAndEnabled));
    }

    public Collection<BuildAgent> getRemoteActiveAndEnabledAgents() {
        return AgentStateCache.getOrdering().sortedCopy(Iterables.filter(this.remoteAgents.values(), BuildAgentPredicates::isActiveAndEnabled));
    }

    public Collection<BuildAgent> getElasticActiveAndEnabledAgents() {
        return AgentStateCache.getOrdering().sortedCopy(Iterables.filter(this.onlineElasticAgents.values(), BuildAgentPredicates::isActiveAndEnabled));
    }

    public Collection<LocalBuildAgent> getLocalActiveAndEnabledAgents() {
        return AgentStateCache.getOrdering().sortedCopy(Iterables.filter(this.localAgents.values(), BuildAgentPredicates::isActiveAndEnabled));
    }

    public LocalBuildAgent getLocalAgent(long id) {
        return this.localAgents.get(id);
    }

    public BuildAgent getAgent(long agentId) {
        return this.allAgents.get(agentId);
    }

    private static Ordering<NameProvider> getOrdering() {
        return Comparators.getNameProviderCaseInsensitiveOrdering();
    }
}

