/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationManager;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceState;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLoggerWithoutLogAccess;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.dao.AgentDao;
import com.atlassian.bamboo.buildqueue.dao.ElasticTunnelDefinitionDao;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.buildqueue.manager.AgentStateCache;
import com.atlassian.bamboo.buildqueue.manager.LocalAgentManager;
import com.atlassian.bamboo.buildqueue.properties.DistributedProperties;
import com.atlassian.bamboo.capability.CapabilityManager;
import com.atlassian.bamboo.deployments.execution.service.DeploymentExecutionService;
import com.atlassian.bamboo.deployments.runtime.DeploymentInProgress;
import com.atlassian.bamboo.deployments.runtime.DeploymentsInProgressService;
import com.atlassian.bamboo.event.AgentConfigurationUpdatedEvent;
import com.atlassian.bamboo.event.AgentConfigurationUpdatedEventFactory;
import com.atlassian.bamboo.event.AgentDisabledOrEnabledEvent;
import com.atlassian.bamboo.event.AllAgentsUpdatedEvent;
import com.atlassian.bamboo.license.BambooLicenseException;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.persistence.HibernateLazyReferences;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.BambooSpringUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.bamboo.utils.predicates.BuildAgentPredicates;
import com.atlassian.bamboo.v2.build.BuildCancelledDetails;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.AgentBuildingStatus;
import com.atlassian.bamboo.v2.build.agent.AgentIdleStatus;
import com.atlassian.bamboo.v2.build.agent.AgentOfflineStatus;
import com.atlassian.bamboo.v2.build.agent.AgentStatus;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.BuildAgentImpl;
import com.atlassian.bamboo.v2.build.agent.DefaultBuildAgent;
import com.atlassian.bamboo.v2.build.agent.ExecutableBuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalAgentDefinitionImpl;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgentImpl;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.LocalCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.events.AgentOfflineEvent;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class AgentManagerImpl
implements AgentManager,
LocalAgentManager {
    private static final Logger log = Logger.getLogger(AgentManagerImpl.class);
    @Lazy
    @Inject
    private ElasticImageConfigurationManager elasticImageConfigurationManager;
    @Lazy
    @Inject
    private BuildExecutionManager buildExecutionManager;
    @Lazy
    @Inject
    private AgentAssignmentService agentAssignmentService;
    @Lazy
    @Inject
    private DeploymentExecutionService deploymentExecutionService;
    @Inject
    private AuditLogService auditLogService;
    private final AgentDao agentDao;
    private final AgentStateCache agentStateCache = new AgentStateCache();
    private final CapabilitySetManager capabilitySetManager;
    private final CapabilityManager capabilityManager;
    private final EventPublisher eventPublisher;
    private final BambooLicenseManager bambooLicenseManager;
    private final ElasticInstanceManager elasticInstanceManager;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final BuildLoggerManager buildLoggerManager;
    private final FeatureManager featureManager;
    private final DeploymentsInProgressService deploymentsInProgressService;
    private final ElasticTunnelDefinitionDao elasticTunnelDefinitionDao;
    private static final AgentConfigurationUpdatedEventFactory AGENT_CONFIGURATION_UPDATED_EVENT_FACTORY = AgentConfigurationUpdatedEvent::new;

    public AgentManagerImpl(AgentDao agentDao, CapabilitySetManager capabilitySetManager, CapabilityManager capabilityManager, EventPublisher eventPublisher, BambooLicenseManager bambooLicenseManager, ElasticInstanceManager elasticInstanceManager, ErrorUpdateHandler errorUpdateHandler, BuildLoggerManager buildLoggerManager, FeatureManager featureManager, DeploymentsInProgressService deploymentsInProgressService, ElasticTunnelDefinitionDao elasticTunnelDefinitionDao) {
        this.agentDao = agentDao;
        this.bambooLicenseManager = bambooLicenseManager;
        this.buildLoggerManager = buildLoggerManager;
        this.capabilityManager = capabilityManager;
        this.capabilitySetManager = capabilitySetManager;
        this.deploymentsInProgressService = deploymentsInProgressService;
        this.eventPublisher = eventPublisher;
        this.elasticInstanceManager = elasticInstanceManager;
        this.errorUpdateHandler = errorUpdateHandler;
        this.featureManager = featureManager;
        this.elasticTunnelDefinitionDao = elasticTunnelDefinitionDao;
    }

    public void createDefaultAgent() {
        List pipelineDefinitions = this.agentDao.findAllLocalAgents();
        if (pipelineDefinitions.isEmpty()) {
            LocalAgentDefinitionImpl defaultPipeline = new LocalAgentDefinitionImpl(-1L, "Default Agent");
            defaultPipeline.setCapabilitySet((CapabilitySet)new LocalCapabilitySet());
            this.capabilitySetManager.createAgentCapabilitySet((LocalAgentDefinition)defaultPipeline);
            this.agentDao.save((EntityObject)defaultPipeline);
        }
    }

    public void initAgents() {
        List remoteAgents;
        BuildAgentImpl buildAgent;
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info((Object)"Initialising agents...");
        List localAgents = this.agentDao.findAllLocalAgents();
        HashSet<LocalBuildAgent> initialisedLocalAgents = new HashSet<LocalBuildAgent>();
        HashSet<BuildAgent> initialisedRemoteAgents = new HashSet<BuildAgent>();
        if (!localAgents.isEmpty() && this.featureManager.isLocalAgentsSupported()) {
            log.info((Object)"Initialising local agents...");
            for (Object definition : localAgents) {
                DefaultBuildAgent executableBuildAgent = new DefaultBuildAgent(definition.getId(), definition.getName(), definition.getDescription());
                BambooSpringUtils.autowireComponent((Object)executableBuildAgent);
                buildAgent = new LocalBuildAgentImpl((LocalAgentDefinition)definition, (ExecutableBuildAgent)executableBuildAgent);
                initialisedLocalAgents.add((LocalBuildAgent)buildAgent);
            }
        }
        if (!(remoteAgents = this.agentDao.findAllRemoteAgents()).isEmpty() && this.featureManager.isRemoteAgentsSupported()) {
            log.info((Object)"Initialising remote agents...");
            for (RemoteAgentDefinition definition : remoteAgents) {
                this.updateAgentShutdownTime((DistributedProperties)definition);
                buildAgent = new BuildAgentImpl((PipelineDefinition)definition, AgentOfflineStatus.getInstance());
                initialisedRemoteAgents.add((BuildAgent)buildAgent);
            }
        }
        boolean seamlessRestarts = this.featureManager.isSeamlessRestartEnabled();
        List agents = this.agentDao.findNotShutDownElasticAgents();
        log.info((Object)"Initialising elastic agents...");
        for (ElasticAgentDefinition agentDefinition : agents) {
            if (seamlessRestarts) {
                BuildAgentImpl buildAgent2 = new BuildAgentImpl((PipelineDefinition)agentDefinition, (AgentStatus)AgentIdleStatus.getInstance());
                buildAgent2.setLastUpdated(new Date());
                initialisedRemoteAgents.add((BuildAgent)buildAgent2);
                continue;
            }
            this.updateAgentShutdownTime((DistributedProperties)agentDefinition);
        }
        this.agentStateCache.initialiseAgents(initialisedLocalAgents, initialisedRemoteAgents);
        log.info((Object)("All agents initialized in " + stopwatch));
    }

    public void startLocalAgents() {
        List<LocalBuildAgent> allLocalAgents = this.getAllLocalAgents();
        if (allLocalAgents.size() > 0) {
            log.info((Object)"Starting local agents...");
        }
        for (LocalBuildAgent agent : allLocalAgents) {
            log.debug((Object)("Starting local agent " + agent.getName()));
            agent.getExecutableBuildAgent().start();
        }
    }

    public void stopLocalAgents() {
        log.info((Object)"Stopping all local agents...");
        for (LocalBuildAgent agent : this.getAllLocalAgents()) {
            agent.getExecutableBuildAgent().stop();
        }
    }

    private void updateAgentShutdownTime(@NotNull DistributedProperties agentDefinition) {
        if (agentDefinition.getLastShutdownTime() == null) {
            agentDefinition.setLastShutdownTime(new Date());
            this.agentDao.save((EntityObject)agentDefinition);
            if (agentDefinition instanceof ElasticAgentDefinition) {
                this.elasticTunnelDefinitionDao.removeByAgentId(((ElasticAgentDefinition)agentDefinition).getId());
            }
        }
    }

    @NotNull
    public List<LocalBuildAgent> getAllLocalAgents() {
        return this.agentStateCache.getAllLocalAgents();
    }

    @NotNull
    public List<BuildAgent> getOnlineElasticAgents() {
        return this.agentStateCache.getOnlineElasticAgents();
    }

    @NotNull
    public List<ElasticAgentDefinition> getAllElasticAgentDefinitions(int firstResult, int maxResults) {
        return this.agentDao.findAllElasticAgents(firstResult, maxResults);
    }

    public long getAgentCount(Class<? extends PipelineDefinition> agentDefinitionClass) {
        return this.agentDao.getAgentCount(agentDefinitionClass);
    }

    @NotNull
    public List<ElasticAgentDefinition> getAllElasticAgentDefinitions(@NotNull Collection<String> instanceIds) {
        List allElasticAgents = this.agentDao.findAllElasticAgents(instanceIds);
        HibernateLazyReferences.initialiseAgents((Iterable)allElasticAgents);
        return allElasticAgents;
    }

    @NotNull
    public List<BuildAgent> getAllRemoteAgents(boolean onlineOnly) {
        return this.agentStateCache.getAllRemoteAgents(onlineOnly);
    }

    @NotNull
    public List<BuildAgent> getAllRemoteAgents() {
        return this.getAllRemoteAgents(false);
    }

    @NotNull
    public List<BuildAgent> getAllAgents() {
        return this.agentStateCache.getAllAgents();
    }

    @NotNull
    public List<BuildAgent> getAllNonElasticAgents() {
        return this.agentStateCache.getNonElasticAgents();
    }

    @NotNull
    public Collection<BuildAgent> getBusyBuildAgents() {
        return this.agentStateCache.getBusyBuildAgents();
    }

    @NotNull
    public Collection<BuildAgent> getActiveAndEnabledAgents() {
        return this.agentStateCache.getActiveAndEnabledAgents();
    }

    @NotNull
    public Collection<BuildAgent> getRemoteActiveAndEnabledAgents() {
        return this.agentStateCache.getRemoteActiveAndEnabledAgents();
    }

    @NotNull
    public Collection<BuildAgent> getElasticActiveAndEnabledAgents() {
        return this.agentStateCache.getElasticActiveAndEnabledAgents();
    }

    @NotNull
    public Collection<LocalBuildAgent> getLocalActiveAndEnabledAgents() {
        return this.agentStateCache.getLocalActiveAndEnabledAgents();
    }

    public void createLocalAgent(LocalAgentDefinition definition) throws BambooLicenseException {
        if (definition == null) {
            throw new IllegalArgumentException("Cannot create a null pipeline definition");
        }
        if (!this.allowNewLocalAgent()) {
            throw new BambooLicenseException("Cannot create additional local agent. You have reached the limit for the number of local agents you can have.Please upgrade your license.");
        }
        boolean localAgentsNotSupported = !((FeatureManager)ComponentAccessor.FEATURE_MANAGER.get()).isLocalAgentsSupported();
        boolean isGlobalAdmin = ((BambooPermissionManager)ComponentAccessor.BAMBOO_PERMISSION_MANAGER.get()).hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION);
        if (localAgentsNotSupported && !isGlobalAdmin) {
            throw new IllegalArgumentException("You cannot create local agents on this instance");
        }
        this.savePipeline((PipelineDefinition)definition);
    }

    public void savePipeline(@NotNull PipelineDefinition pipelineDefinition) {
        this.savePipeline(pipelineDefinition, AGENT_CONFIGURATION_UPDATED_EVENT_FACTORY);
    }

    public void savePipeline(@NotNull PipelineDefinition pipelineDefinition, @Nullable AgentConfigurationUpdatedEventFactory eventFactory) {
        Preconditions.checkArgument((pipelineDefinition != null ? 1 : 0) != 0, (Object)"Cannot save a null pipeline definition");
        pipelineDefinition.accept(new PipelineDefinitionVisitor(){

            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                throw new IllegalArgumentException("Cannot register elastic agents as regular agent");
            }

            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                if (pipelineDefinition.getCapabilitySet() == null) {
                    AgentManagerImpl.this.capabilitySetManager.createAgentCapabilitySet(pipelineDefinition);
                }
            }

            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                if (pipelineDefinition.getCapabilitySet() == null) {
                    AgentManagerImpl.this.capabilitySetManager.createAgentCapabilitySet(pipelineDefinition);
                }
            }
        });
        pipelineDefinition = this.agentDao.saveAndReturn(pipelineDefinition);
        BuildAgent buildAgent = this.agentStateCache.updateAgentInCache(pipelineDefinition);
        if (eventFactory != null) {
            this.eventPublisher.publish(eventFactory.create((Object)this, buildAgent));
        }
    }

    public void saveElasticPipeline(@NotNull ElasticAgentDefinition elasticDefinition) {
        this.saveElasticPipeline(elasticDefinition, AGENT_CONFIGURATION_UPDATED_EVENT_FACTORY);
    }

    public void saveReturningElasticPipeline(@NotNull ElasticAgentDefinition elasticDefinition) {
        Preconditions.checkArgument((boolean)this.elasticInstanceManager.isElasticSupportEnabled(), (Object)"Cannot save Elastic Agent, Elastic Bamboo has not been enabled");
        if (elasticDefinition.getElasticImageConfiguration() == null) {
            throw new RuntimeException(String.format("Image id '%s' doesn't exist, can not save returning elastic agent %d", elasticDefinition.getElasticImageId(), elasticDefinition.getId()));
        }
        String instanceId = elasticDefinition.getElasticInstanceId();
        if (instanceId == null) {
            throw new RuntimeException(String.format("Returning elastic agent %d is missing instance id.", elasticDefinition.getId()));
        }
        RemoteElasticInstance elasticInstance = this.elasticInstanceManager.getElasticRemoteAgentByInstanceId(instanceId);
        if (elasticInstance == null) {
            throw new RuntimeException(String.format("Elastic instance '%s' doesn't exist, can not save returning elastic agent %d", instanceId, elasticDefinition.getId()));
        }
        if (elasticInstance.getState() != RemoteElasticInstanceState.RUNNING) {
            throw new RuntimeException(String.format("Can not save returning elastic agent %d on a not running instance. Elastic instance '%s' state is %s.", elasticDefinition.getId(), instanceId, elasticInstance.getState()));
        }
        elasticInstance.setAgentLoading(false);
        log.debug((Object)String.format("Saving definition of a returning elastic agent %d", elasticDefinition.getId()));
        elasticDefinition = (ElasticAgentDefinition)this.agentDao.saveAndReturn((PipelineDefinition)elasticDefinition);
        this.agentStateCache.updateAgentInCache((PipelineDefinition)elasticDefinition);
    }

    private void saveElasticPipeline(@NotNull ElasticAgentDefinition elasticDefinition, @Nullable AgentConfigurationUpdatedEventFactory eventFactory) {
        String imageFilesVersionOnAgent;
        String imageFilesVersionInConfig;
        Preconditions.checkArgument((elasticDefinition != null ? 1 : 0) != 0, (Object)"Cannot save a null pipeline definition");
        Preconditions.checkArgument((boolean)this.elasticInstanceManager.isElasticSupportEnabled(), (Object)"Cannot save Elastic Agent, Elastic Bamboo has not been enabled");
        String imageId = elasticDefinition.getElasticImageId();
        ElasticImageConfiguration image = elasticDefinition.getElasticImageConfiguration();
        if (image == null) {
            image = this.elasticImageConfigurationManager.getElasticImageConfigurationById(elasticDefinition.getElasticImageConfigurationId());
            if (image != null) {
                elasticDefinition.setElasticImageConfiguration(image);
            } else {
                throw new IllegalArgumentException("Image ID: " + imageId + "  is invalid, can not save elastic agent.");
            }
        }
        if (!Objects.equals(imageFilesVersionInConfig = image.getImageFilesVersion(), imageFilesVersionOnAgent = elasticDefinition.getImageFilesVersion())) {
            image.setImageFilesVersion(imageFilesVersionOnAgent);
            this.elasticImageConfigurationManager.saveElasticImageConfiguration(image);
        }
        elasticDefinition = (ElasticAgentDefinition)this.agentDao.saveAndReturn((PipelineDefinition)elasticDefinition);
        BuildAgent buildAgent = this.agentStateCache.updateAgentInCache((PipelineDefinition)elasticDefinition);
        String instanceId = elasticDefinition.getElasticInstanceId();
        if (instanceId != null) {
            RemoteElasticInstance elasticInstance = this.elasticInstanceManager.getElasticRemoteAgentByInstanceId(instanceId);
            if (elasticInstance != null) {
                elasticInstance.setRemoteAgent(elasticDefinition.getId());
                elasticInstance.setAgentLoading(false);
                this.elasticInstanceManager.addElasticLogEntry(log, "Elastic Agent \"" + elasticDefinition.getName() + "\" started on instance " + instanceId);
            } else {
                this.elasticInstanceManager.addElasticLogEntry(log, "Elastic Agent \"" + elasticDefinition.getName() + "\" started on instance " + instanceId + " but this instance doesn't exist.");
            }
        } else {
            this.elasticInstanceManager.addElasticLogEntry(log, "Elastic Agent \"" + elasticDefinition.getName() + "\" started with no instance id");
        }
        if (eventFactory != null) {
            this.eventPublisher.publish(eventFactory.create((Object)this, buildAgent));
        }
    }

    public List<PipelineDefinition> getAllPersistedAgentDefinitions() {
        return this.agentDao.findAllAgents();
    }

    private void abandonDeployment(@NotNull BuildAgent remoteAgent, boolean agentStartingUp, boolean foundBuildRunning, boolean shouldDetachOnly) {
        DeploymentInProgress deploymentInProgress = this.deploymentsInProgressService.getDeploymentExecutingOnAgent(remoteAgent.getId());
        if (deploymentInProgress == null) {
            log.info((Object)("No deployments running on agent " + remoteAgent.getName()));
            return;
        }
        if (foundBuildRunning) {
            log.error((Object)"We have both build and deployment registered as running on agent.");
        }
        if (shouldDetachOnly) {
            this.deploymentsInProgressService.detachDeploymentFromAgent(remoteAgent.getId());
            return;
        }
        String errorMessage = "Agent '" + remoteAgent.getName() + "' " + (!agentStartingUp ? "went offline" : "was restarted") + " while deploying " + deploymentInProgress.getDeploymentVersionName() + " on " + deploymentInProgress.getEnvironmentName() + ". Deployment failed. ";
        log.error((Object)errorMessage);
        BuildLoggerWithoutLogAccess buildLogger = this.buildLoggerManager.getLoggerWithoutLogAccess((Key)deploymentInProgress.getResultKey());
        buildLogger.addErrorLogEntry(errorMessage);
        ImpersonationHelper.runWithSystemAuthority((BambooRunnables.ThrowingX)((BambooRunnables.NotThrowing)() -> this.deploymentExecutionService.terminateDeployment(deploymentInProgress.getResultKey())));
    }

    public void abandonBuild(@NotNull BuildAgent remoteAgent, boolean agentStartingUp) {
        boolean shouldDetachOnly = this.featureManager.isAgentBuildResiliencyOn() && agentStartingUp && remoteAgent.getType() != AgentType.LOCAL;
        CurrentlyBuilding runningOnAgent = this.buildExecutionManager.getBuildRunningOnAgent(Long.valueOf(remoteAgent.getId()));
        this.abandonDeployment(remoteAgent, agentStartingUp, runningOnAgent != null, shouldDetachOnly);
        if (runningOnAgent == null) {
            log.info((Object)("No builds running on agent " + remoteAgent.getName()));
            return;
        }
        BuildIdentifier buildIdentifier = runningOnAgent.getBuildIdentifier();
        if (shouldDetachOnly) {
            this.buildExecutionManager.detachBuildFromAgent(remoteAgent.getId());
            return;
        }
        if (!runningOnAgent.tryToFinish()) {
            log.info((Object)("Agent being closed but result summary for " + runningOnAgent.getBuildIdentifier().getPlanResultKey() + " already being saved."));
            return;
        }
        String errorMessage = "Agent '" + remoteAgent.getName() + "' " + (!agentStartingUp ? "went offline" : "was restarted") + " while building " + buildIdentifier.getBuildResultKey() + ". The results of that build will not be available. ";
        log.error((Object)errorMessage);
        this.errorUpdateHandler.recordError((ResultKey)buildIdentifier.getPlanResultKey(), errorMessage, null);
        BuildLoggerWithoutLogAccess buildLogger = this.buildLoggerManager.getLoggerWithoutLogAccess((Key)buildIdentifier.getPlanResultKey());
        buildLogger.addErrorLogEntry(errorMessage);
        boolean isForcedCancellation = true;
        BuildCancelledDetails bcd = new BuildCancelledDetails(new Date(), true);
        runningOnAgent.setBuildCancelledDetails(bcd);
        this.buildExecutionManager.finishBuild(buildIdentifier.getPlanResultKey(), true);
    }

    public void onAgentReturning(@NotNull BuildAgent agent) {
        this.stopAgent(agent, true);
    }

    public void stopAgent(@NotNull BuildAgent agent) {
        this.stopAgent(agent, false);
    }

    private void stopAgent(final @NotNull BuildAgent agent, boolean returningAgent) {
        this.abandonBuild(agent, returningAgent);
        if (agent.getAgentStatus() instanceof AgentOfflineStatus) {
            log.info((Object)("The agent [" + agent.getName() + "] is already offline"));
            return;
        }
        Preconditions.checkArgument((boolean)(agent instanceof BuildAgentImpl), (Object)"Incompatible type of agent.");
        ((BuildAgentImpl)agent).setAgentStatus(AgentOfflineStatus.getInstance());
        agent.getDefinition().accept(new PipelineDefinitionVisitor(){

            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                AgentManagerImpl.this.agentStateCache.removeFromCache(agent);
                AgentManagerImpl.this.updateAgentShutdownTime((DistributedProperties)pipelineDefinition);
                String instanceId = (String)MoreObjects.firstNonNull((Object)pipelineDefinition.getElasticInstanceId(), (Object)"UNKNOWN");
                AgentManagerImpl.this.elasticInstanceManager.addElasticLogEntry(log, "Elastic Agent \"" + pipelineDefinition.getName() + "\" stopped on instance " + instanceId);
            }

            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
            }

            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                AgentManagerImpl.this.updateAgentShutdownTime((DistributedProperties)pipelineDefinition);
            }
        });
        this.eventPublisher.publish((Object)new AgentOfflineEvent((Object)this, agent));
    }

    public LocalBuildAgent getLocalAgent(long pipelineId) {
        return this.agentStateCache.getLocalAgent(pipelineId);
    }

    @Nullable
    public BuildAgent getAgent(long agentId) {
        PipelineDefinition pipelineDefinition;
        BuildAgent agent = this.agentStateCache.getAgent(agentId);
        if (agent == null && (pipelineDefinition = this.agentDao.getAgentById(agentId)) != null) {
            agent = new BuildAgentImpl(pipelineDefinition, AgentOfflineStatus.getInstance());
        }
        return agent;
    }

    @Nullable
    public PipelineDefinition getAgentDefinition(@NotNull Long agentId) {
        BuildAgent buildAgent = this.getAgent(agentId);
        return buildAgent != null ? buildAgent.getDefinition() : null;
    }

    public Map<Long, PipelineDefinition> findAllAgentsForAgentIds(@NotNull Collection<Long> agentIds) {
        HashMap<Long, PipelineDefinition> resultsToAgentMap = new HashMap<Long, PipelineDefinition>();
        if (!agentIds.isEmpty()) {
            Set pipelineDefinitions = this.agentDao.findAllAgentsForAgentIds(agentIds);
            for (PipelineDefinition pipelineDefinition : pipelineDefinitions) {
                resultsToAgentMap.put(pipelineDefinition.getId(), pipelineDefinition);
            }
        }
        return resultsToAgentMap;
    }

    @Nullable
    public PipelineDefinition getAgentDefinitionByName(@NotNull String name) {
        return this.agentDao.findAgentByName(name);
    }

    @NotNull
    public List<PipelineDefinition> getAgentDefinitionsWithNameLike(@NotNull String likeName) {
        return this.agentDao.findAllAgentsWithNameLike(likeName);
    }

    public void saveAnyPipeline(@NotNull PipelineDefinition pipelineDefinition) {
        this.saveAnyPipeline(pipelineDefinition, AGENT_CONFIGURATION_UPDATED_EVENT_FACTORY);
    }

    public void saveAnyPipeline(@NotNull PipelineDefinition pipelineDefinition, final @Nullable AgentConfigurationUpdatedEventFactory eventFactory) {
        pipelineDefinition.accept(new PipelineDefinitionVisitor(){

            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                AgentManagerImpl.this.saveElasticPipeline(pipelineDefinition, eventFactory);
            }

            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                AgentManagerImpl.this.savePipeline((PipelineDefinition)pipelineDefinition, eventFactory);
            }

            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                AgentManagerImpl.this.savePipeline((PipelineDefinition)pipelineDefinition, eventFactory);
            }
        });
    }

    public void disableAllAgents() {
        for (BuildAgent buildAgent : this.agentStateCache.getAllAgents()) {
            PipelineDefinition pipelineDefinition = buildAgent.getDefinition();
            pipelineDefinition.setEnabled(false);
            pipelineDefinition.accept(new PipelineDefinitionVisitor(){

                public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                    AgentManagerImpl.this.saveElasticPipeline(pipelineDefinition, null);
                }

                public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                    AgentManagerImpl.this.savePipeline((PipelineDefinition)pipelineDefinition, null);
                }

                public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                    AgentManagerImpl.this.savePipeline((PipelineDefinition)pipelineDefinition, null);
                }
            });
        }
        this.eventPublisher.publish((Object)new AllAgentsUpdatedEvent((Object)this));
    }

    public void enableAllAgents() {
        for (BuildAgent buildAgent : this.agentStateCache.getAllAgents()) {
            PipelineDefinition pipelineDefinition = buildAgent.getDefinition();
            pipelineDefinition.setEnabled(true);
            pipelineDefinition.accept(new PipelineDefinitionVisitor(){

                public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                    AgentManagerImpl.this.saveElasticPipeline(pipelineDefinition, null);
                }

                public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                    AgentManagerImpl.this.savePipeline((PipelineDefinition)pipelineDefinition, null);
                }

                public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                    AgentManagerImpl.this.savePipeline((PipelineDefinition)pipelineDefinition, null);
                }
            });
        }
        this.eventPublisher.publish((Object)new AllAgentsUpdatedEvent((Object)this));
    }

    public boolean checkPipelinesAreDisabled() {
        return this.agentStateCache.getAllAgents().stream().noneMatch(BuildAgentPredicates::isEnabled);
    }

    public <T> T executeIfIdle(Callable<T> callable) throws Exception {
        return callable.call();
    }

    public void removeAgent(long agentId) throws TimeoutException {
        EntityObject agentEntityObject;
        BuildAgent anyBuildAgent;
        PipelineDefinition agent;
        log.info((Object)"Attempting to remove build agent... ");
        LocalBuildAgent localBuildAgent = this.getLocalAgent(agentId);
        if (localBuildAgent != null) {
            localBuildAgent.getExecutableBuildAgent().stop();
            localBuildAgent.getExecutableBuildAgent().waitForStop(30);
        }
        if ((agent = this.agentDao.getAgentById(agentId)) != null) {
            ReadOnlyCapabilitySet combinedCapabilitySet = this.capabilitySetManager.getCombinedCapabilitySet(agentId);
            if (combinedCapabilitySet != null && agent.getType() != AgentType.ELASTIC) {
                this.capabilityManager.removeCapabilities(Long.valueOf(agentId), (Collection)combinedCapabilitySet.getCapabilities().stream().map(Capability::getKey).collect(Collectors.toSet()));
            }
            boolean directAssignmentsOnly = true;
            this.agentAssignmentService.deleteExecutableAssignments((Iterable)this.agentAssignmentService.getAgentAssignments().forExecutors(AgentAssignmentServiceHelper.asExecutors((PipelineDefinition)agent, (boolean)directAssignmentsOnly)));
        }
        if ((anyBuildAgent = this.getAgent(agentId)) != null) {
            this.agentStateCache.removeFromCache(anyBuildAgent);
        }
        if ((agentEntityObject = (EntityObject)Narrow.reinterpret((Object)agent, EntityObject.class)) != null) {
            this.agentDao.remove(agentEntityObject);
        }
    }

    public boolean allowNewRemoteAgent() {
        return this.allowNewRemoteAgents(1);
    }

    public boolean allowNewRemoteAgents(int numOfAgentsToCreate) {
        int allowed = this.bambooLicenseManager.getAllowedNumberOfRemoteAgents();
        if (allowed < 0) {
            return true;
        }
        int licensesUsedByElastic = this.elasticInstanceManager.getTotalNumElasticRemoteAgents();
        boolean onlineOnly = true;
        int onlineNonElasticRemoteAgents = this.getAllRemoteAgents(true).size() - this.getOnlineElasticAgents().size();
        return licensesUsedByElastic + onlineNonElasticRemoteAgents + numOfAgentsToCreate <= allowed;
    }

    public boolean allowNewElasticAgent() {
        return this.allowNewElasticAgents(1);
    }

    public boolean allowNewElasticAgents(int numOfAgentsToCreate) {
        int allowed = this.bambooLicenseManager.getAllowedNumberOfRemoteAgents();
        if (allowed < 0) {
            return true;
        }
        boolean onlineOnly = true;
        return this.getAllRemoteAgents(true).size() + numOfAgentsToCreate <= allowed;
    }

    public boolean allowNewLocalAgent() {
        int allowed = this.bambooLicenseManager.getAllowedNumberOfLocalAgents();
        if (allowed < 0) {
            return true;
        }
        int onlineLocalAgents = this.getAllLocalAgents().size();
        return onlineLocalAgents < allowed;
    }

    public boolean updateAgentStatusIfResultReturnPossibleAfterServerRestart(long agentId, ResultKey resultKey, String displayName, long deploymentResultId) {
        BuildAgent agent = this.getAgent(agentId);
        boolean canReturnResult = false;
        if (agent == null) {
            return false;
        }
        if (agent.getType() == AgentType.REMOTE) {
            canReturnResult = true;
        } else if (agent.getType() == AgentType.ELASTIC) {
            boolean bl = canReturnResult = ((ElasticAgentDefinition)agent.getDefinition()).getLastShutdownTime() == null;
        }
        if (canReturnResult && agent instanceof BuildAgentImpl) {
            BuildAgentImpl buildAgent = (BuildAgentImpl)agent;
            buildAgent.setAgentStatus((AgentStatus)new AgentBuildingStatus(resultKey, displayName, deploymentResultId));
            buildAgent.setLastUpdated(new Date());
            return true;
        }
        return false;
    }

    public Optional<BuildAgent> setAgentEnabled(long agentId, boolean enable) {
        PipelineDefinition agent;
        BuildAgent buildAgent = this.getAgent(agentId);
        if (buildAgent != null && (agent = buildAgent.getDefinition()).isEnabled() != enable) {
            agent.setEnabled(enable);
            this.saveAnyPipeline(agent, AgentDisabledOrEnabledEvent::new);
            this.auditLogService.log("Agent '" + agent.getName() + "' has been " + (enable ? "Enabled" : "Disabled"));
        }
        return Optional.ofNullable(buildAgent);
    }
}

