/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap.classloading;

import com.atlassian.bamboo.agent.bootstrap.classloading.ClassLoaderObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class ClassLoaderUtils {
    private static final Logger log = LogManager.getLogger(ClassLoaderUtils.class);

    private ClassLoaderUtils() {
    }

    public static Thread newThreadWithIsolatedClassloader(ClassLoader isolatedClassLoader, Class<? extends Runnable> runnable, Serializable ... ctorArgs) {
        Runnable runnableObject = ClassLoaderUtils.instantiateRunnable(isolatedClassLoader, runnable, ctorArgs);
        Thread thread = new Thread(runnableObject);
        thread.setContextClassLoader(isolatedClassLoader);
        return thread;
    }

    @NotNull
    public static Function<File, URL> toUrl() {
        return file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.warn("", (Throwable)e);
                return null;
            }
        };
    }

    @NotNull
    private static Runnable instantiateRunnable(ClassLoader classLoader, Class<? extends Runnable> runnable, Serializable[] ctorArgs) {
        Runnable runnableObject;
        Class<?> runnableClass;
        try {
            runnableClass = classLoader.loadClass(runnable.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("The isolated classloader cannot find " + String.valueOf(runnable), e);
        }
        Constructor<?>[] constructors = runnableClass.getDeclaredConstructors();
        if (constructors.length == 0) {
            throw new IllegalArgumentException("The runnable " + String.valueOf(runnable) + " does not have a constructor");
        }
        Constructor<?> constructor = constructors[0];
        constructor.setAccessible(true);
        try {
            runnableObject = (Runnable)constructor.newInstance(ClassLoaderUtils.transferToNewClassLoader(classLoader, ctorArgs));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Cannot instantiate " + String.valueOf(runnable), e);
        }
        return runnableObject;
    }

    private static Object[] transferToNewClassLoader(ClassLoader classLoader, Serializable ... objects) {
        ArrayList<Object> newObjects = new ArrayList<Object>();
        for (Serializable object : objects) {
            newObjects.add(ClassLoaderUtils.fromByteArray(classLoader, ClassLoaderUtils.toByteArray(object)));
        }
        return newObjects.toArray(new Object[0]);
    }

    public static byte[] toByteArray(Serializable o) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(out);){
            oos.writeObject(o);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialise class " + String.valueOf(o.getClass()), e);
        }
        return out.toByteArray();
    }

    public static Object fromByteArray(ClassLoader classLoader, byte[] buf) {
        Object object;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buf);
        ClassLoaderObjectInputStream is = new ClassLoaderObjectInputStream(classLoader, inputStream);
        try {
            object = is.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException("Unable to deserialize class", e);
            }
        }
        is.close();
        return object;
    }
}

