/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SslKeystoreUtils {
    public static KeyStore loadKeyStore() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, NoSuchProviderException {
        return SslKeystoreUtils.loadKeyStore(SslKeystoreUtils.getKeyStoreFile(), SslKeystoreUtils.getKeystorePassword(), System.getProperty("javax.net.ssl.keyStoreType"), System.getProperty("javax.net.ssl.keyStoreProvider"));
    }

    @Nullable
    public static KeyStore loadTrustStore() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, NoSuchProviderException {
        String trustStoreFile = SslKeystoreUtils.getTrustStoreFile();
        return SslKeystoreUtils.loadKeyStore(trustStoreFile, System.getProperty("javax.net.ssl.trustStorePassword"), System.getProperty("javax.net.ssl.trustStoreType"), System.getProperty("javax.net.ssl.trustStoreProvider"));
    }

    public static KeyStore loadKeyStore(@NotNull String storeFile, @Nullable String password, @Nullable String keyStoreType, @Nullable String provider) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        KeyStore store = provider == null ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(keyStoreType, provider);
        try (FileInputStream instream = new FileInputStream(storeFile);){
            store.load(instream, password != null ? password.toCharArray() : null);
        }
        return store;
    }

    private static String getKeyStoreFile() {
        return System.getProperty("javax.net.ssl.keyStore");
    }

    @Nullable
    public static String getKeystorePassword() {
        return System.getProperty("javax.net.ssl.keyStorePassword");
    }

    public static boolean isKeyStoreConfigured() {
        return SslKeystoreUtils.getKeyStoreFile() != null;
    }

    @Nullable
    private static String getTrustStoreFile() {
        return System.getProperty("javax.net.ssl.trustStore");
    }

    public static boolean isTrustStoreConfigured() {
        return SslKeystoreUtils.getTrustStoreFile() != null;
    }
}

