/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.agent.bootstrap.AgentBootstrap;
import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import com.atlassian.bamboo.agent.bootstrap.http.RemoteAgentHttpClientFactory;
import com.atlassian.bamboo.agent.bootstrap.http.RemoteAgentSchemeRegistryFactory;
import com.atlassian.bamboo.agent.bootstrap.http.SchemeRegistryFactory;
import com.atlassian.bamboo.utils.LogUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.Nullable;

public class RemoteAgentBootstrap {
    private static final Logger log = LogManager.getLogger(AgentBootstrap.class);
    private static final String AGENT_SERVER = "agentServer";
    private static final String BAMBOO_AGENT_EPHEMERAL_PREFIX = "bamboo.agent.ephemeral";
    private static final String AGENT_FOR_PROPERTY_NAME = "bamboo.agent.ephemeral.for.key";
    private static final String EPHEMERAL_APPROVAL_PROPERTY_NAME = "bamboo.agent.ephemeral.approval.turnedoff";
    private static final String AGENT_TEMPLATE_ID = "bamboo.agent.ephemeral.template.id";
    private static final String AGENT_POD_NAME = "bamboo.agent.ephemeral.pod.name";
    private static final String IDENTITY_ENCODING = "identity";
    private static URL cachedFinalUrl;
    protected final AgentType agentType;
    protected URL declaredEndpointForAgents;
    @Nullable
    protected final String securityToken;

    public static void main(String[] arguments) throws Exception {
        AgentType agentType = RemoteAgentBootstrap.isEphemeralAgent() ? AgentType.EPHEMERAL : AgentType.REMOTE;
        AgentTypeHolder.set((AgentType)agentType);
        RemoteAgentBootstrap.configureLogging();
        String javaVersion = System.getProperty("java.version");
        String jvmVendor = System.getProperty("java.vm.vendor");
        System.setProperty("com.atlassian.plugin.legacy.wiring.autodetection.mode", "true");
        Charset defaultCharset = Charset.defaultCharset();
        String fileNameEncoding = System.getProperty("sun.jnu.encoding");
        log.info("Starting Agent Bootstrap using Java {} from {}. Default charset: {}, file name encoding: {}", (Object)javaVersion, (Object)jvmVendor, (Object)defaultCharset, (Object)fileNameEncoding);
        if (arguments.length == 1 || arguments.length == 2) {
            String message;
            try {
                String bambooUrl = RemoteAgentBootstrap.getBambooUrl(arguments[0], agentType);
                log.info("Using Bamboo URL: {}", (Object)bambooUrl);
                String securityToken = arguments.length == 2 && !arguments[1].isEmpty() ? arguments[1] : null;
                RemoteAgentBootstrap agentBootstrap = new RemoteAgentBootstrap(new URL(bambooUrl), securityToken, agentType);
                agentBootstrap.run(agentType);
            }
            catch (IOException e) {
                message = String.format("Error following redirects for Bamboo URL: %s", arguments[0]);
                log.error(message, (Throwable)e);
                System.err.println(e.getMessage());
                System.exit(1);
            }
            catch (URISyntaxException e) {
                message = String.format("Invalid Bamboo URL provided: %s", arguments[0]);
                log.error(message, (Throwable)e);
                System.err.println(message);
                System.exit(1);
            }
        } else {
            StringBuilder message = new StringBuilder("Incorrect command line syntax.");
            if (arguments.length == 0) {
                message.append(" Single argument expected, no arguments were passed.");
            } else {
                message.append(" Maximum two arguments allowed. ").append(arguments.length).append(" arguments were passed: ");
                for (String argument : arguments) {
                    message.append(argument).append(" ");
                }
            }
            log.error((CharSequence)message);
            System.err.println(message);
            System.exit(1);
        }
    }

    private static boolean isEphemeralAgent() {
        return Strings.isNotBlank((String)System.getProperty(AGENT_FOR_PROPERTY_NAME)) && Strings.isNotBlank((String)System.getProperty(AGENT_TEMPLATE_ID)) && Strings.isNotBlank((String)System.getProperty(AGENT_POD_NAME));
    }

    protected static void configureLogging() {
        URI customLog4jUri = LogUtils.getCustomLog4jConfigurationURI();
        LoggerContext context = (LoggerContext)LogManager.getContext((ClassLoader)LogManager.class.getClassLoader(), (boolean)false);
        boolean customConfigurationFailed = false;
        if (customLog4jUri != null) {
            log.info("Using custom logging configuration for Agent boostrap: {}", (Object)customLog4jUri);
            context.setConfigLocation(customLog4jUri);
            StatusLogger statusLogger = StatusLogger.getLogger();
            if (statusLogger.getStatusData().isEmpty()) {
                log.info("Agent bootstrap logging configuration finished");
                return;
            }
            customConfigurationFailed = true;
        }
        try {
            context.setConfigLocation(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("defaultLogging.properties")).toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Configuring log4j2 failed", e);
        }
        if (LogUtils.isLog4jVersion1CustomPathDefined()) {
            log.warn("LOG4J: Ignoring custom log4j 1 configuration at {}. Use {} property instead.", (Object)LogUtils.getLog4jVersion1CustomPath(), (Object)"log4j2.configurationFile");
        }
        if (customConfigurationFailed) {
            log.error("LOG4J: Custom configuration at {} is invalid, using defaults", (Object)LogUtils.getCustomLog4jConfiguration());
        }
    }

    protected RemoteAgentBootstrap(URL serverEndpointForAgents, @Nullable String securityToken) {
        this(serverEndpointForAgents, securityToken, AgentType.REMOTE);
    }

    protected RemoteAgentBootstrap(URL serverEndpointForAgents, @Nullable String securityToken, AgentType agentType) {
        this.securityToken = securityToken;
        this.agentType = agentType;
        try {
            this.declaredEndpointForAgents = new URL(RemoteAgentBootstrap.getBambooUrl(serverEndpointForAgents.toString(), agentType));
        }
        catch (IOException | URISyntaxException e) {
            log.error("Failed to get the Bamboo URL", (Throwable)e);
            this.declaredEndpointForAgents = serverEndpointForAgents;
        }
    }

    protected AgentContext createAgentContext(AgentType type, URL endpointForAgents) throws MalformedURLException {
        return new AgentContext(this.newHttpClientFactory(), endpointForAgents, this.getFingerprintRequestSuffix(), type, this.securityToken, System.getProperty(AGENT_FOR_PROPERTY_NAME));
    }

    protected void run(AgentType type) {
        try {
            URL endpointToUse = this.getReachableEndpointForAgents();
            log.info("Agent bootstrap using endpoint: {}", (Object)endpointToUse);
            AgentContext agentContext = this.createAgentContext(type, endpointToUse);
            agentContext.run();
        }
        catch (Throwable throwable) {
            throw RemoteAgentBootstrap.handleFatalException(throwable);
        }
    }

    public RemoteAgentHttpClientFactory newHttpClientFactory() {
        RemoteAgentHttpClientFactory remoteAgentHttpClientFactory = new RemoteAgentHttpClientFactory();
        SchemeRegistryFactory schemeRegistryFactory = this.getSchemeRegistryDataFactory(new RemoteAgentSchemeRegistryFactory());
        remoteAgentHttpClientFactory.setSchemeRegistryDataFactory(schemeRegistryFactory);
        this.setHttpClientFactoryParamaters(remoteAgentHttpClientFactory);
        return remoteAgentHttpClientFactory;
    }

    protected void setHttpClientFactoryParamaters(RemoteAgentHttpClientFactory remoteAgentHttpClientFactory) {
    }

    protected boolean isHttpsBaseURL() {
        return "https".equals(this.declaredEndpointForAgents.getProtocol());
    }

    protected final URL getDeclaredEndpointForAgents() {
        return this.declaredEndpointForAgents;
    }

    protected URL getReachableEndpointForAgents() {
        return this.declaredEndpointForAgents;
    }

    protected SchemeRegistryFactory getSchemeRegistryDataFactory(SchemeRegistryFactory remoteAgentSchemeRegistryFactory) {
        return remoteAgentSchemeRegistryFactory;
    }

    static Error handleFatalException(Throwable throwable) {
        String FATAL_ERROR_MESSAGE = "Exiting due to fatal exception.";
        System.err.println("Exiting due to fatal exception.");
        throwable.printStackTrace();
        log.fatal("Exiting due to fatal exception.", throwable);
        System.exit(1);
        throw new Error("FATAL_ERROR_MESSAGE", throwable);
    }

    protected String getFingerprintRequestSuffix() {
        return RemoteAgentBootstrap.isEphemeralAgent() || Boolean.parseBoolean(System.getProperty(EPHEMERAL_APPROVAL_PROPERTY_NAME)) ? "&agentType=ephemeral" : "";
    }

    private static URL getFinalUrlWithRedirects(String initialUrl) throws IOException, URISyntaxException {
        int maxRedirects = 6;
        String cacheTestPath = "/bootstrap/content-cache-test";
        if (cachedFinalUrl != null) {
            return cachedFinalUrl;
        }
        URI currentUri = new URI(initialUrl);
        int redirectCount = 0;
        RemoteAgentBootstrap.isUsingProxy(currentUri);
        while (redirectCount < 6) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().useSystemProperties().disableRedirectHandling();
            CloseableHttpClient httpClient = httpClientBuilder.build();
            try {
                HttpGet httpGet = new HttpGet(currentUri);
                httpGet.addHeader("Accept-Encoding", IDENTITY_ENCODING);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                int statusCode = response.getStatusLine().getStatusCode();
                log.debug("Status code: {}", (Object)statusCode);
                if (statusCode >= 300 && statusCode < 400) {
                    String location = response.getFirstHeader("Location").getValue();
                    log.debug("Redirect location: {}", (Object)location);
                    URI newUri = currentUri.resolve(location);
                    log.debug("New URL after iteration {}: {}", (Object)redirectCount, (Object)newUri);
                    currentUri = newUri;
                    ++redirectCount;
                } else {
                    if (statusCode == 404) {
                        HttpGet httpGetCacheTest = new HttpGet(String.valueOf(currentUri) + "/bootstrap/content-cache-test");
                        httpGetCacheTest.addHeader("Accept-Encoding", IDENTITY_ENCODING);
                        CloseableHttpResponse responseCacheTest = httpClient.execute((HttpUriRequest)httpGetCacheTest);
                        int statusCodeCacheTest = responseCacheTest.getStatusLine().getStatusCode();
                        if (statusCodeCacheTest == 200) {
                            String responseBody = new String(responseCacheTest.getEntity().getContent().readAllBytes(), Charset.defaultCharset()).trim();
                            log.debug("Response body from {}: {}", (Object)httpGetCacheTest.getURI().getPath(), (Object)responseBody);
                            try {
                                int responseNumber = Integer.parseInt(responseBody);
                                if (responseNumber <= 0) {
                                    throw new NumberFormatException();
                                }
                                cachedFinalUrl = currentUri.toURL();
                                break;
                            }
                            catch (NumberFormatException e) {
                                String errMessage = String.format("The Bamboo URL or its HTTP redirection chain does not point to a valid Bamboo server. Expected a numeric response from %s. Check your configuration.", httpGetCacheTest.getURI());
                                log.error(errMessage);
                                throw new IOException(errMessage, e);
                            }
                        }
                        throw new IOException("The URL does not point to a valid Bamboo server: " + String.valueOf(currentUri));
                    }
                    if (statusCode != 200) break;
                    cachedFinalUrl = currentUri.toURL();
                    break;
                }
                httpGet.releaseConnection();
            }
            finally {
                if (httpClient == null) continue;
                httpClient.close();
            }
        }
        if (redirectCount > 0) {
            log.info("Agent has received {} HTTP redirect response(s) while connecting to the provided URL: {}", (Object)redirectCount, (Object)initialUrl);
        }
        if (cachedFinalUrl == null) {
            throw new IOException("Unable to determine a valid Bamboo server URL from: " + initialUrl);
        }
        return cachedFinalUrl;
    }

    public static boolean isUsingProxy(URI currentUri) {
        Proxy proxy;
        ProxySelector defaultProxySelector = ProxySelector.getDefault();
        List<Proxy> proxies = defaultProxySelector.select(currentUri);
        if (!proxies.isEmpty() && (proxy = proxies.get(0)).type() != Proxy.Type.DIRECT) {
            InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
            log.info("Using {} proxy: {}:{}", (Object)currentUri.getScheme(), (Object)proxyAddress.getHostName(), (Object)proxyAddress.getPort());
            return true;
        }
        return false;
    }

    private static String getBambooUrl(String argument, AgentType agentType) throws IOException, URISyntaxException {
        log.debug("Initial Bamboo URL: {}", (Object)argument);
        Object agentServerUrl = argument.endsWith("/agentServer") || argument.endsWith("/agentServer/") ? argument : (argument.endsWith("/") ? argument + "agentServer/" : argument + "/agentServer");
        if (!argument.equals(agentServerUrl)) {
            log.debug("New Bamboo URL with adjusted URI: {}", agentServerUrl);
        }
        if (agentType == AgentType.ELASTIC) {
            return argument;
        }
        return RemoteAgentBootstrap.getFinalUrlWithRedirects((String)agentServerUrl).toString();
    }
}

