/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.BambooHttpUtils;
import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import com.atlassian.bamboo.agent.bootstrap.AgentFileManifestDao;
import com.atlassian.bamboo.agent.bootstrap.BootstrapStringUtils;
import com.atlassian.bamboo.agent.bootstrap.BootstrapUtils;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHttpException;
import com.atlassian.bamboo.agent.bootstrap.classloading.ClassLoaderUtils;
import com.atlassian.bamboo.agent.bootstrap.classloading.ConditionallyDelegatingUrlClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class ClasspathBuilder {
    public static final String HEADER_ATLASSIAN_BAMBOO_INSTANCE_FINGERPRINT = "Atlassian-Bamboo-Fingerprint";
    public static final String HEADER_ATLASSIAN_BAMBOO_SERVER_FINGERPRINT = "Atlassian-Bamboo-Server-Fingerprint";
    private static final Logger log = LogManager.getLogger(ClasspathBuilder.class);
    public static final String CLASSPATH_SERVLET = "bootstrap";
    private static final String CLASSPATH_SERVLET_WITH_TRAILING_SLASH = "bootstrap/";
    public static final String MANIFEST_PATH = "/manifest";
    public static final String CACHE_TEST_PATH = "/content-cache-test";
    public static final String COLLECTION_ID_CLASSPATH = "classpath";
    public static final String COLLECTION_ID_USER_INSTALLED_PLUGINS = "user-installed-plugins";
    public static final String COLLECTION_ID_SYSTEM_PROVIDED_PLUGINS = "system-provided-plugins";
    public static final String COLLECTION_ID_FRAMEWORK_BUNDLES = "framework-bundles";

    private ClasspathBuilder() {
    }

    public static ClassLoader getClassLoader(File home, AgentContext agentContext) throws IOException {
        ClasspathBuilder.testCaching(agentContext);
        List<File> agentFiles = ClasspathBuilder.sync(agentContext, home, COLLECTION_ID_CLASSPATH);
        Object[] urls = (URL[])agentFiles.stream().map(ClassLoaderUtils.toUrl()).filter(Objects::nonNull).toArray(URL[]::new);
        log.info("Classpath: " + Arrays.toString(urls));
        return new ConditionallyDelegatingUrlClassLoader((URL[])urls);
    }

    private static void testCaching(AgentContext agentContext) throws IOException {
        String result2;
        String cacheTestUrl = agentContext.getAbsoluteUrl("bootstrap/content-cache-test");
        String result1 = (String)agentContext.getHttpClient().execute((HttpUriRequest)new HttpGet(cacheTestUrl), response -> EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8));
        if (result1.equals(result2 = (String)agentContext.getHttpClient().execute((HttpUriRequest)new HttpGet(cacheTestUrl), response -> EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8)))) {
            log.info("Content caching is enabled for high performance bootstrap.");
        } else {
            log.warn("Content caching is not enabled. This can cause performance impact on servers with high-tier licenses.");
        }
    }

    @NotNull
    public static List<File> sync(AgentContext agentContext, File home, String collectionId) throws IOException {
        String url = agentContext.getAbsoluteUrl(CLASSPATH_SERVLET_WITH_TRAILING_SLASH + collectionId + MANIFEST_PATH);
        log.info("Syncing " + String.valueOf(home) + " with " + url);
        List<AgentFileManifestDao.AgentFileManifestEntry> allFilesInCollection = AgentFileManifestDao.parse(ClasspathBuilder.getJarList(agentContext, ClasspathBuilder.newHttpGet(agentContext, url)));
        List<AgentFileManifestDao.AgentFileManifestEntry> toDownload = allFilesInCollection.stream().filter(entry -> {
            File file = ClasspathBuilder.fileInHomeDirectory(home, entry);
            file.getParentFile().mkdirs();
            if (!file.exists()) {
                return true;
            }
            if (file.length() != entry.getFileLength()) {
                return true;
            }
            try {
                long fileChecksum = BootstrapUtils.calculateAdlerChecksum(file);
                return !Long.toString(fileChecksum).equals(entry.getFileEtag());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        ClasspathBuilder.removeSpuriousFiles(home, allFilesInCollection, toDownload);
        log.info("Server publishes " + allFilesInCollection.size() + " files, we need to download " + toDownload.size());
        long startTimeStamp = System.currentTimeMillis();
        ClasspathBuilder.download(agentContext, collectionId, home, toDownload);
        long elapsedTime = System.currentTimeMillis() - startTimeStamp;
        log.info("Collection " + collectionId + " downloaded in " + elapsedTime + " ms");
        return allFilesInCollection.stream().map(file -> ClasspathBuilder.fileInHomeDirectory(home, file)).collect(Collectors.toList());
    }

    private static List<File> toFiles(File home, List<AgentFileManifestDao.AgentFileManifestEntry> agentFiles) {
        return agentFiles.stream().map(entry -> ClasspathBuilder.fileInHomeDirectory(home, entry)).collect(Collectors.toList());
    }

    private static void removeSpuriousFiles(File home, List<AgentFileManifestDao.AgentFileManifestEntry> allFiles, List<AgentFileManifestDao.AgentFileManifestEntry> toDownload) {
        Set controlledSubdirectories = allFiles.stream().map(AgentFileManifestDao.AgentFileManifestEntry::getRawFileLocation).map(location -> BootstrapStringUtils.substringBeforeLast(location, "/")).map(relative -> new File(home, (String)relative)).collect(Collectors.toSet());
        Set allRequiredFiles = allFiles.stream().map(AgentFileManifestDao.AgentFileManifestEntry::getRawFileLocation).map(relative -> new File(home, (String)relative)).collect(Collectors.toSet());
        for (File dir : controlledSubdirectories) {
            for (File file : dir.listFiles()) {
                if (allRequiredFiles.contains(file)) continue;
                log.info("Removing " + String.valueOf(file));
                boolean delete = file.delete();
                if (delete) continue;
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to delete: " + String.valueOf(file), e);
                }
            }
        }
    }

    @NotNull
    private static File fileInHomeDirectory(File home, AgentFileManifestDao.AgentFileManifestEntry entry) {
        return new File(home, entry.getRawFileLocation());
    }

    @NotNull
    private static HttpGet newHttpGet(AgentContext agentContext, String url) {
        HttpGet method = new HttpGet(url);
        BootstrapUtils.addFingerprintHeader(agentContext, (AbstractHttpMessage)method);
        return method;
    }

    private static void download(AgentContext agentContext, String collectionId, File home, Iterable<AgentFileManifestDao.AgentFileManifestEntry> filesToDownload) throws IOException {
        for (AgentFileManifestDao.AgentFileManifestEntry file : filesToDownload) {
            String relativeUrl = CLASSPATH_SERVLET_WITH_TRAILING_SLASH + collectionId + "/" + ClasspathBuilder.urlEncoded(file) + "/" + file.getFileEtag();
            String absoluteUrl = agentContext.getAbsoluteUrl(relativeUrl);
            HttpGet httpGet = ClasspathBuilder.newHttpGet(agentContext, absoluteUrl);
            agentContext.getHttpClient().execute((HttpUriRequest)httpGet, response -> {
                Header lastHeader;
                if (response.getStatusLine().getStatusCode() != 200) {
                    ClasspathBuilder.terminateWithError(response, "retrieval of " + absoluteUrl);
                }
                String length = (lastHeader = response.getLastHeader("Content-Length")) != null ? lastHeader.getValue() : "?";
                log.info("Downloaded: " + file.getRawFileLocation() + " " + length + " bytes");
                BootstrapUtils.copyResponseToFile(response, Paths.get(home.getAbsolutePath(), file.getRawFileLocation()));
                return true;
            });
        }
    }

    private static String urlEncoded(AgentFileManifestDao.AgentFileManifestEntry file) {
        String urlEncoded = BootstrapStringUtils.encodeForUrl(file.getRawFileLocation());
        return urlEncoded.replace("%2F", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getJarList(AgentContext agentContext, HttpGet method) throws IOException {
        while (true) lbl-1000:
        // 3 sources

        {
            response = agentContext.getHttpClient().execute((HttpUriRequest)method);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    s = EntityUtils.toString((HttpEntity)response.getEntity());
                    br = new BufferedReader(new StringReader(s));
                    try {
                        var5_6 = br.lines().collect(Collectors.toList());
                        return var5_6;
                    }
                    finally {
                        br.close();
                    }
                }
                case 503: {
                    try {
                        headers = response.getHeaders("Retry-After");
                        waitTime = headers.length != 0 ? Long.parseLong(headers[0].getValue()) : 60L;
                        ClasspathBuilder.log.info("Server is starting up or is busy loading other agents. Waiting for " + waitTime + " seconds before retrying");
                        TimeUnit.SECONDS.sleep(waitTime);
                        ** break;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Wait interrupted", e);
                    }
                }
            }
            return ClasspathBuilder.terminateWithError(response, "manifest retrieval");
            finally {
                method.reset();
                continue;
            }
            break;
        }
    }

    private static List<String> terminateWithError(HttpResponse response, String context) throws IOException {
        log.debug(BambooHttpUtils.entityToString(response));
        log.error("An error has occurred when retrieving classpath data: " + String.valueOf(response.getStatusLine()));
        throw new RemoteAgentHttpException(response.getStatusLine(), context);
    }
}

