/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.http.HttpResponse;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BootstrapUtils {
    private static final Logger log = LogManager.getLogger(BootstrapUtils.class);
    public static final int BUFFER_SIZE = 4096;

    private BootstrapUtils() {
    }

    public static long calculateAdlerChecksum(File file) throws IOException {
        return BootstrapUtils.calculateChecksum(file, new Adler32());
    }

    public static long calculateCrc32(File file) throws IOException {
        return BootstrapUtils.calculateChecksum(file, new CRC32());
    }

    private static long calculateChecksum(File file, Checksum checksum) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            BootstrapUtils.calculateStreamChecksum(inputStream, checksum);
            long l = checksum.getValue();
            return l;
        }
    }

    private static void calculateStreamChecksum(InputStream inputStream, Checksum checksum) throws IOException {
        byte[] buffer = new byte[4096];
        int read = inputStream.read(buffer, 0, 4096);
        while (read > -1) {
            checksum.update(buffer, 0, read);
            read = inputStream.read(buffer, 0, 4096);
        }
    }

    public static void copyStream(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        BootstrapUtils.copyStream(inputStream, outputStream, new ProgressMonitor(2){

            @Override
            public void onIntervalReached(long currentBytes) {
                log.info(currentBytes / 1024L / 1024L + " MBs transferred");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(@NotNull InputStream inputStream, @NotNull OutputStream outputStream, @Nullable ProgressMonitor progressMonitor) throws IOException {
        try {
            int n;
            byte[] buffer = new byte[4096];
            int totalCopied = 0;
            while ((n = inputStream.read(buffer)) != -1) {
                int curMbCopied;
                int prevMbCopied;
                outputStream.write(buffer, 0, n);
                if (progressMonitor == null || (prevMbCopied = totalCopied / 1024 / 1024) == (curMbCopied = (totalCopied += n) / 1024 / 1024) || curMbCopied % progressMonitor.getIntervalMb() != 0) continue;
                progressMonitor.onIntervalReached(totalCopied);
            }
        }
        finally {
            outputStream.close();
        }
    }

    public static void copyResponseToFile(HttpResponse response, Path file) throws IOException {
        try (InputStream content = response.getEntity().getContent();){
            BootstrapUtils.copyStreamToFile(content, file);
        }
    }

    public static void copyStreamToFile(InputStream inputStream, final Path file) throws IOException {
        try (OutputStream fileOutputStream = Files.newOutputStream(file, new OpenOption[0]);){
            BootstrapUtils.copyStream(inputStream, fileOutputStream, new ProgressMonitor(2){

                @Override
                public void onIntervalReached(long currentBytes) {
                    log.info(String.valueOf(file) + ": " + currentBytes / 1024L / 1024L + " MBs transferred");
                }
            });
        }
    }

    public static void addFingerprintHeader(AgentContext agentContext, AbstractHttpMessage req) {
        req.addHeader("Atlassian-Bamboo-Server-Fingerprint", agentContext.getServerFingerprint());
        req.addHeader("Atlassian-Bamboo-Fingerprint", Long.toString(agentContext.getInstanceFingerprint()));
    }

    public static abstract class ProgressMonitor {
        private final int intervalMb;

        public ProgressMonitor(int intervalMb) {
            this.intervalMb = intervalMb;
        }

        public int getIntervalMb() {
            return this.intervalMb;
        }

        public abstract void onIntervalReached(long var1);
    }
}

