/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHomeLocatorForBootstrap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public final class AgentUuidInitializer {
    private static final Logger log = LogManager.getLogger(AgentUuidInitializer.class);
    public static final String PROPERTY_UUID = "agentUuid";
    private final File agentHome;
    private final File agentConfigFile;
    private final File temporaryUuidFile;

    public AgentUuidInitializer() {
        this.agentHome = RemoteAgentHomeLocatorForBootstrap.getHome();
        this.agentConfigFile = RemoteAgentHomeLocatorForBootstrap.getConfigFile();
        this.temporaryUuidFile = new File(this.agentHome, RemoteAgentHomeLocatorForBootstrap.getTemporaryUuidFileName());
    }

    public AgentUuidInitializer(File agentHome) {
        this.agentHome = agentHome;
        this.agentConfigFile = new File(agentHome, RemoteAgentHomeLocatorForBootstrap.getDefaultConfigFileName());
        this.temporaryUuidFile = new File(agentHome, RemoteAgentHomeLocatorForBootstrap.getTemporaryUuidFileName());
    }

    public File tempUuidFile() {
        return this.temporaryUuidFile;
    }

    public UUID initUuid() {
        String uuidFromConfig = this.readFromConfigFiles();
        UUID parsed = this.tryParse(uuidFromConfig);
        if (parsed != null) {
            return parsed;
        }
        UUID newUuid = UUID.randomUUID();
        log.info("Generating new UUID for this agent: " + String.valueOf(newUuid));
        this.storeInTempUuidFile(newUuid);
        return newUuid;
    }

    public String readFromConfigFiles() {
        String fromMainConfig = this.readFromAgentConfigFile();
        if (this.isNotEmpty(fromMainConfig)) {
            return fromMainConfig;
        }
        return this.readFromTempUuidFile();
    }

    private String readFromAgentConfigFile() {
        if (!this.agentConfigFile.isFile()) {
            log.debug("Unable to retrieve existing UUID. Agent config file does not yet exist");
            return null;
        }
        try {
            DocumentBuilderFactory dbf = this.newSecureDocumentBuilderFactory();
            dbf.setNamespaceAware(true);
            Document configDoc = dbf.newDocumentBuilder().parse(this.agentConfigFile);
            XPathExpression xpath = XPathFactory.newInstance().newXPath().compile("/configuration/agentUuid");
            String uuid = xpath.evaluate(configDoc);
            if (this.isNotEmpty(uuid)) {
                log.info("Found agent UUID '" + uuid + "' in agent config file ");
            }
            return uuid;
        }
        catch (Exception e) {
            log.warn("Exception while trying to read UUID from agent config file '" + this.agentConfigFile.getAbsolutePath() + "': " + String.valueOf(e));
            if (log.isDebugEnabled()) {
                log.debug("Exception while trying to read UUID from agent config file", (Throwable)e);
            }
            return null;
        }
    }

    private DocumentBuilderFactory newSecureDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return dbf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readFromTempUuidFile() {
        if (!this.temporaryUuidFile.isFile()) {
            log.debug("Unable to retrieve existing UUID. Temporary UUID file does not yet exist");
            return null;
        }
        try (FileInputStream tempUuidStream = new FileInputStream(this.temporaryUuidFile);){
            Properties uuidProps = new Properties();
            uuidProps.load(tempUuidStream);
            String uuid = uuidProps.getProperty(PROPERTY_UUID);
            if (this.isNotEmpty(uuid)) {
                log.info("Found agent UUID '" + uuid + "' in temporary UUID file '" + this.temporaryUuidFile.getAbsolutePath() + "'");
                String string = uuid;
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            log.warn("Exception while trying to read UUID from temp UUID file '" + this.temporaryUuidFile.getAbsolutePath() + "': " + String.valueOf(e));
            if (!log.isDebugEnabled()) return null;
            log.debug("Exception while trying to read UUID from temp UUID file", (Throwable)e);
            return null;
        }
    }

    private UUID tryParse(String uuid) {
        if (this.isEmpty(uuid)) {
            return null;
        }
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            log.warn("Exception while parsing UUID '" + uuid + "' retrieved from config file: " + String.valueOf(e));
            if (log.isDebugEnabled()) {
                log.debug("Exception while parsing UUID '" + uuid + "' retrieved from config file", (Throwable)e);
            }
            return null;
        }
    }

    private void storeInTempUuidFile(UUID newUuid) {
        Properties uuidProps = new Properties();
        uuidProps.setProperty(PROPERTY_UUID, newUuid.toString());
        try (FileOutputStream uuidFileStream = new FileOutputStream(this.temporaryUuidFile);){
            uuidProps.store(uuidFileStream, "Agent UUID stored here temporarily until the agent is approved");
        }
        catch (Exception e) {
            log.warn("Unable to store newly generated UUID '" + String.valueOf(newUuid) + "' in the temporary config file '" + this.temporaryUuidFile.getAbsolutePath() + "'. This means a new UUID will have to be generated and approved once this agent is restarted", (Throwable)e);
        }
    }

    private boolean isNotEmpty(String string) {
        return string != null && !string.trim().isEmpty();
    }

    private boolean isEmpty(String string) {
        return !this.isNotEmpty(string);
    }
}

