/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentBootstrap;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class AgentRunner
implements Runnable {
    private static final Logger log = LogManager.getLogger(AgentRunner.class);
    private final AgentContext context;
    private final String agentClassName;

    AgentRunner(AgentContext context, String agentClassName) {
        this.context = context;
        this.agentClassName = agentClassName;
    }

    @Override
    public void run() {
        try {
            AgentTypeHolder.set((AgentType)this.context.getAgentBootstrapType());
            Class<?> agentClass = this.getClassForName(this.agentClassName);
            Method startMethod = agentClass.getDeclaredMethod("start", AgentContext.class);
            Object agent = agentClass.newInstance();
            startMethod.invoke(agent, this.context);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (NoSuchMethodException e) {
            log.error("Cannot find methods necessary to recreate context and start the agent", (Throwable)e);
        }
        catch (Throwable throwable) {
            throw RemoteAgentBootstrap.handleFatalException(throwable);
        }
    }

    private Class<?> getClassForName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
    }
}

