/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHomeLocatorForBootstrap;
import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public final class AgentIdInitializer {
    private static final Logger log = LogManager.getLogger(AgentIdInitializer.class);
    public static final String PROPERTY_ID = "id";
    private static final String PROPERTY_ID_PATH = "/configuration/agentDefinition/id";
    private final File agentConfigFile;

    public AgentIdInitializer() {
        this.agentConfigFile = RemoteAgentHomeLocatorForBootstrap.getConfigFile();
    }

    public AgentIdInitializer(File agentHome) {
        this.agentConfigFile = new File(agentHome, RemoteAgentHomeLocatorForBootstrap.getDefaultConfigFileName());
    }

    @Nullable
    public Long initAgentId() {
        String agentIdString = this.readFromAgentConfigFile();
        if (this.isNotEmpty(agentIdString)) {
            return Long.parseLong(agentIdString);
        }
        return null;
    }

    private String readFromAgentConfigFile() {
        if (!this.agentConfigFile.isFile()) {
            log.debug("Unable to retrieve existing UUID. Agent config file does not yet exist");
            return null;
        }
        try {
            DocumentBuilderFactory dbf = this.newSecureDocumentBuilderFactory();
            dbf.setNamespaceAware(true);
            Document configDoc = dbf.newDocumentBuilder().parse(this.agentConfigFile);
            XPathExpression xpath = XPathFactory.newInstance().newXPath().compile(PROPERTY_ID_PATH);
            String agentId = xpath.evaluate(configDoc);
            if (this.isNotEmpty(agentId)) {
                log.info("Found agent id '" + agentId + "' in agent config file ");
            }
            return agentId;
        }
        catch (Exception e) {
            log.warn("Exception while trying to read id from agent config file '" + this.agentConfigFile.getAbsolutePath() + "': " + String.valueOf(e));
            if (log.isDebugEnabled()) {
                log.debug("Exception while trying to read id from agent config file", (Throwable)e);
            }
            return null;
        }
    }

    private DocumentBuilderFactory newSecureDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return dbf;
    }

    private boolean isNotEmpty(String string) {
        return string != null && !string.trim().isEmpty();
    }

    private boolean isEmpty(String string) {
        return !this.isNotEmpty(string);
    }
}

