/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.BootstrapStringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class AgentFileManifestDao {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final Pattern PIPE_SPLITTER = Pattern.compile("|", 16);
    private static final Pattern REPLACE_BUCKET_VAR = Pattern.compile("${agentDataBucket}", 16);

    private AgentFileManifestDao() {
    }

    public static void write(File file, Map<String, Collection<AgentFileManifestEntry>> filesScheduledForUpload) {
        try (PrintWriter pw = AgentFileManifestDao.getPrintWriter(file);){
            AgentFileManifestDao.write(pw, filesScheduledForUpload);
        }
    }

    public static void write(PrintWriter pw, Map<String, Collection<AgentFileManifestEntry>> files) {
        for (Map.Entry<String, Collection<AgentFileManifestEntry>> collectionIdAndKey : files.entrySet()) {
            String collectionId = collectionIdAndKey.getKey();
            for (AgentFileManifestEntry entry : collectionIdAndKey.getValue()) {
                pw.println(collectionId + "|" + entry.getRawFileLocation() + "|" + entry.getFileLength() + "|" + entry.getFileEtag());
            }
        }
    }

    public static List<AgentFileManifestEntry> parse(File file) {
        try {
            return AgentFileManifestDao.parse(Files.readAllLines(file.toPath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<AgentFileManifestEntry> parse(List<String> entries) {
        return entries.stream().map(line -> {
            String[] split = PIPE_SPLITTER.split((CharSequence)line);
            Long length = Long.valueOf(split[2]);
            return new AgentFileManifestEntry(split[0], split[1], length, split[3]);
        }).collect(Collectors.toList());
    }

    @NotNull
    private static PrintWriter getPrintWriter(File file) {
        try {
            return new PrintWriter(file, UTF_8.name());
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class AgentFileManifestEntry {
        public static final String AGENT_DATA_BUCKET = "agentDataBucket";
        private final String collectionId;
        private final String fileLocation;
        private final long fileLength;
        private final String fileEtag;
        private final String filename;

        public AgentFileManifestEntry(String collectionId, String fileLocation, long fileLength, String fileEtag) {
            this.collectionId = collectionId;
            this.fileLocation = fileLocation;
            this.filename = BootstrapStringUtils.substringAfterLast(fileLocation, "/");
            this.fileLength = fileLength;
            this.fileEtag = fileEtag;
        }

        public String getCollectionId() {
            return this.collectionId;
        }

        public String getRawFileLocation() {
            return this.fileLocation;
        }

        public String getFileLocation(String agentDataBucket) {
            return REPLACE_BUCKET_VAR.matcher(this.fileLocation).replaceAll(agentDataBucket);
        }

        public long getFileLength() {
            return this.fileLength;
        }

        public String getFileEtag() {
            return this.fileEtag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AgentFileManifestEntry entry = (AgentFileManifestEntry)o;
            if (!this.collectionId.equals(entry.collectionId)) {
                return false;
            }
            return this.filename.equals(entry.filename);
        }

        public int hashCode() {
            int result = this.collectionId.hashCode();
            result = 31 * result + this.filename.hashCode();
            return result;
        }

        public String toString() {
            return "AgentFileManifestEntry{collectionId='" + this.collectionId + "', fileLocation='" + this.fileLocation + "', fileLength=" + this.fileLength + ", fileEtag='" + this.fileEtag + "', filename='" + this.filename + "'}";
        }
    }
}

