/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.model;

import com.atlassian.aws.ec2.model.ResourceId;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VpcId
extends ResourceId<VpcId> {
    private static final VpcId NO_VPC = new VpcId(false);

    public VpcId(@NotNull String id) {
        super(id);
        Preconditions.checkArgument((boolean)id.startsWith("vpc-"));
    }

    private VpcId(boolean b) {
        super("");
    }

    public boolean isUndefined() {
        return this == NO_VPC;
    }

    public static VpcId from(@Nullable String vpcId) {
        return StringUtils.isBlank((CharSequence)vpcId) ? NO_VPC : new VpcId(vpcId);
    }
}

