/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.configuration;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.awssdk.RegionSupport;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ImageData {
    private final List<ImageDefinition> imageDefinitions = new ArrayList<ImageDefinition>();
    private String assemblyBucketStem;
    private String serverVersionSpecificDataKey;
    private String bootstrapKey;

    public String getAssemblyBucketStem() {
        return this.assemblyBucketStem;
    }

    public String getAssemblyBucket(AwsSupportConstants.Region region) {
        return ImageData.getNameForRegion(this.assemblyBucketStem, region);
    }

    public void setAssemblyBucketStem(String assemblyBucketStem) {
        this.assemblyBucketStem = assemblyBucketStem;
    }

    public String getServerVersionSpecificDataKey() {
        return this.serverVersionSpecificDataKey;
    }

    public void setServerVersionSpecificDataKey(String serverVersionSpecificDataKey) {
        this.serverVersionSpecificDataKey = serverVersionSpecificDataKey;
    }

    public String getBootstrapKey() {
        return this.bootstrapKey;
    }

    public void setBootstrapKey(String bootstrapKey) {
        this.bootstrapKey = bootstrapKey;
    }

    public ImageData add(ImageDefinition imageDefinition) {
        this.imageDefinitions.add(imageDefinition);
        return this;
    }

    @NotNull
    public List<ImageDefinition> getImageDefinitions() {
        return this.imageDefinitions;
    }

    @NotNull
    public static String getNameForRegion(@NotNull String nameStem, @NotNull AwsSupportConstants.Region region) {
        return nameStem + "-" + region.getNormalisedName();
    }

    @NotNull
    public static String getNameForAwsRegion(@NotNull String nameStem, @NotNull Region region) {
        return nameStem + "-" + RegionSupport.getBucketNameSuffix(region);
    }

    public static class ImageDefinition {
        @NotNull
        private final Regions region;
        private final AwsSupportConstants.RootDeviceType rootDeviceType;
        private final AwsSupportConstants.Architecture imageArchitecture;
        private final AwsSupportConstants.Platform imagePlatform;
        private final AwsSupportConstants.Virtualisation virtualisation;
        private final String osName;
        private String imageId;

        public ImageDefinition(@NotNull Regions region, @NotNull AwsSupportConstants.RootDeviceType rootDeviceType, @NotNull AwsSupportConstants.Architecture imageArchitecture, @NotNull AwsSupportConstants.Platform imagePlatform, @NotNull AwsSupportConstants.Virtualisation virtualisation, @NotNull String osName, @NotNull String imageId) {
            this.region = region;
            this.rootDeviceType = rootDeviceType;
            this.imageArchitecture = imageArchitecture;
            this.imagePlatform = imagePlatform;
            this.virtualisation = virtualisation;
            this.osName = osName;
            this.imageId = imageId;
        }

        public String getImageId() {
            return this.imageId;
        }

        public void setImageId(String value) {
            this.imageId = value;
        }

        public AwsSupportConstants.Region getRegion() {
            return RegionSupport.toAtlassianAwsRegion(this.region);
        }

        @NotNull
        public Regions getAwsSdkRegion() {
            return this.region;
        }

        public AwsSupportConstants.RootDeviceType getRootDeviceType() {
            return this.rootDeviceType;
        }

        public AwsSupportConstants.Architecture getImageArchitecture() {
            return this.imageArchitecture;
        }

        public AwsSupportConstants.Platform getImagePlatform() {
            return this.imagePlatform;
        }

        public AwsSupportConstants.Virtualisation getVirtualisation() {
            return this.virtualisation;
        }

        public String getOsName() {
            return this.osName;
        }
    }
}

