/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class RegionSupport {
    private static final Map<Region, String> REGION_NAMES = new HashMap<Region, String>();

    private RegionSupport() {
    }

    private static void addRegion(Regions region, String bucketNameSuffix) {
        String previous = REGION_NAMES.put(Region.getRegion((Regions)region), bucketNameSuffix);
        if (previous != null) {
            throw new IllegalArgumentException("Duplicate value for " + region);
        }
    }

    public static String getBucketNameSuffix(Region region) {
        String name = REGION_NAMES.get(region);
        if (name == null) {
            throw new IllegalArgumentException("Unknown region " + region);
        }
        return name;
    }

    public static String getBucketNameSuffix(Regions region) {
        String name = REGION_NAMES.get(RegionSupport.toRegion(region));
        if (name == null) {
            throw new IllegalArgumentException("Unknown region " + region);
        }
        return name;
    }

    public static Regions toRegions(Region region) {
        return Regions.fromName((String)region.getName());
    }

    public static Region toRegion(Regions region) {
        return RegionUtils.getRegion((String)region.getName());
    }

    @NotNull
    public static AwsSupportConstants.Region toAtlassianAwsRegion(@NotNull Regions regionEnum) {
        Region region = RegionSupport.toRegion(regionEnum);
        for (AwsSupportConstants.Region atlRegion : AwsSupportConstants.Region.values()) {
            if (!Objects.equals(atlRegion.getSdkRegion(), region)) continue;
            return atlRegion;
        }
        throw new IllegalArgumentException("Unable to map " + regionEnum + "  to atlassian-aws region");
    }

    @NotNull
    public static Regions toAwsSdkRegion(@NotNull AwsSupportConstants.Region atlRegion) {
        return Regions.fromName((String)atlRegion.getSdkRegion().getName());
    }

    static {
        RegionSupport.addRegion(Regions.CA_CENTRAL_1, "ca-c1");
        RegionSupport.addRegion(Regions.CA_WEST_1, "ca_w1");
        RegionSupport.addRegion(Regions.US_ISO_EAST_1, "us-iso-e1");
        RegionSupport.addRegion(Regions.US_ISOB_EAST_1, "us-isob-e1");
        RegionSupport.addRegion(Regions.US_ISO_WEST_1, "us-iso-w1");
        RegionSupport.addRegion(Regions.US_EAST_1, "us-e1");
        RegionSupport.addRegion(Regions.US_EAST_2, "us-e2");
        RegionSupport.addRegion(Regions.US_WEST_1, "us-w1");
        RegionSupport.addRegion(Regions.US_WEST_2, "us-w2");
        RegionSupport.addRegion(Regions.EU_CENTRAL_1, "eu-c1");
        RegionSupport.addRegion(Regions.EU_CENTRAL_2, "eu-central-2");
        RegionSupport.addRegion(Regions.EU_NORTH_1, "eu-n1");
        RegionSupport.addRegion(Regions.EU_SOUTH_1, "eu-south-1");
        RegionSupport.addRegion(Regions.EU_SOUTH_2, "eu-south-2");
        RegionSupport.addRegion(Regions.EU_WEST_1, "eu-w1");
        RegionSupport.addRegion(Regions.EU_WEST_2, "eu-w2");
        RegionSupport.addRegion(Regions.EU_WEST_3, "eu-w3");
        RegionSupport.addRegion(Regions.AF_SOUTH_1, "af-s1");
        RegionSupport.addRegion(Regions.AP_EAST_1, "ap-e1");
        RegionSupport.addRegion(Regions.AP_SOUTHEAST_1, "ap-se1");
        RegionSupport.addRegion(Regions.AP_SOUTHEAST_2, "ap-se2");
        RegionSupport.addRegion(Regions.AP_SOUTHEAST_3, "ap-se3");
        RegionSupport.addRegion(Regions.AP_SOUTHEAST_4, "ap-se4");
        RegionSupport.addRegion(Regions.AP_NORTHEAST_1, "ap-ne1");
        RegionSupport.addRegion(Regions.AP_NORTHEAST_2, "ap-ne2");
        RegionSupport.addRegion(Regions.AP_NORTHEAST_3, "ap-ne3");
        RegionSupport.addRegion(Regions.AP_SOUTH_1, "ap-s1");
        RegionSupport.addRegion(Regions.AP_SOUTH_2, "ap-south-2");
        RegionSupport.addRegion(Regions.SA_EAST_1, "sa-east-1");
        RegionSupport.addRegion(Regions.GovCloud, "us-gov-w1");
        RegionSupport.addRegion(Regions.US_GOV_EAST_1, "us-gov-e1");
        RegionSupport.addRegion(Regions.CN_NORTH_1, "cn-n1");
        RegionSupport.addRegion(Regions.CN_NORTHWEST_1, "cn-nw1");
        RegionSupport.addRegion(Regions.ME_SOUTH_1, "me-south1");
        RegionSupport.addRegion(Regions.ME_CENTRAL_1, "me-central-1");
        RegionSupport.addRegion(Regions.IL_CENTRAL_1, "il-central-1");
    }
}

