/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.model.InstanceType;
import com.atlassian.aws.ec2.InstancePaymentType;
import com.atlassian.aws.ec2.InstanceReservationDescription;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.model.SubnetId;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceStatus {
    private volatile long deadline;
    private volatile InstancePaymentType instancePaymentType;
    private volatile String spotInstanceRequestId;
    private volatile String instanceId;
    private volatile Date launchTime;
    private volatile String availabilityZone;
    private String address;
    private String hostname;
    public long startupTime = 0L;
    private long sensibleIdCreationTime;
    private SubnetId subnetId;
    private InstanceType instanceType;
    private volatile AwsSupportConstants.InstanceStateName state;

    public void setDeadline(int timeoutInSeconds) {
        this.deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutInSeconds);
    }

    boolean isDeadlinePassed() {
        return System.currentTimeMillis() > this.deadline;
    }

    public InstancePaymentType getInstancePaymentType() {
        return this.instancePaymentType;
    }

    public void setInstancePaymentType(InstancePaymentType instancePaymentType) {
        this.instancePaymentType = instancePaymentType;
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public void setSpotInstanceRequestId(String spotInstanceRequestId) {
        if (this.spotInstanceRequestId == null && this.instanceId == null) {
            this.sensibleIdCreationTime = System.currentTimeMillis();
        }
        this.spotInstanceRequestId = spotInstanceRequestId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        if (instanceId == null) {
            this.sensibleIdCreationTime = System.currentTimeMillis();
        }
        this.instanceId = instanceId;
    }

    @Nullable
    public String getSensibleId() {
        return this.instanceId != null ? this.instanceId : this.spotInstanceRequestId;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddressAndHostname(@NotNull InstanceReservationDescription instance) {
        this.address = instance.getAddress();
        this.hostname = instance.getHostname();
    }

    public String getHostname() {
        return this.hostname;
    }

    @Nullable
    public Date getLaunchTime() {
        return this.launchTime;
    }

    public void setLaunchTime(Date launchTime) {
        this.launchTime = launchTime;
    }

    public void onStartupAttempt() {
        this.startupTime = System.currentTimeMillis();
    }

    public void setStartupTime(long startupTime) {
        this.startupTime = startupTime;
    }

    public long getSecondsSinceStartupAttempt() {
        Preconditions.checkState((this.startupTime != 0L ? 1 : 0) != 0);
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.startupTime);
    }

    public boolean isSensibleIdOlderThan(long awsResourceIdPropagationTimeMs) {
        return this.sensibleIdCreationTime + awsResourceIdPropagationTimeMs < System.currentTimeMillis();
    }

    public void setSubnetId(@Nullable SubnetId subnetId) {
        this.subnetId = subnetId;
    }

    public InstanceType getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType;
    }

    public AwsSupportConstants.InstanceStateName getState() {
        return this.state;
    }

    public void setState(AwsSupportConstants.InstanceStateName state) {
        this.state = state;
    }
}

