/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.IpRange;
import com.amazonaws.services.ec2.model.Ipv6Range;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.Protocol;
import org.jetbrains.annotations.NotNull;

public final class AmazonEc2Utils {
    private AmazonEc2Utils() {
    }

    public static void ensureInboundTrafficIsAllowed(AmazonEC2 amazonEc2, @NotNull SecurityGroup group, @NotNull Protocol protocol, @NotNull String cidrIpRange, int port) {
        boolean permissionAlreadyExists;
        boolean bl = permissionAlreadyExists = !EC2Utils.getMatchingIpPermissions(group, protocol, cidrIpRange, port).isEmpty();
        if (permissionAlreadyExists) {
            return;
        }
        IpPermission ipPermission = new IpPermission().withIpProtocol(protocol.getValue()).withFromPort(Integer.valueOf(port)).withToPort(Integer.valueOf(port));
        if (AmazonEc2Utils.isIpv6Range(cidrIpRange)) {
            ipPermission.withIpv6Ranges(new Ipv6Range[]{new Ipv6Range().withCidrIpv6(cidrIpRange)});
        } else {
            ipPermission.withIpv4Ranges(new IpRange[]{new IpRange().withCidrIp(cidrIpRange)});
        }
        AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest = new AuthorizeSecurityGroupIngressRequest().withGroupId(group.getGroupId()).withIpPermissions(new IpPermission[]{ipPermission});
        amazonEc2.authorizeSecurityGroupIngress(authorizeSecurityGroupIngressRequest);
    }

    private static boolean isIpv6Range(String cidrIpRange) {
        return cidrIpRange.contains(":");
    }
}

