/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.AmazonEC2AsyncClientBuilder;
import com.atlassian.aws.Ec2ClientFactory;
import com.atlassian.aws.HttpClientConfigurationUtilsDoNotUse;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ec2ClientFactoryImpl
implements Ec2ClientFactory {
    private static final Logger log = Logger.getLogger(Ec2ClientFactoryImpl.class);
    private static final String EC2_TRANSMISSION_TIMEOUT_PROPERTY = "atlassian.ec2.transmission.timeout";
    private static final int DEFAULT_TRANSMISSION_TIMEOUT_SECONDS = 50;
    private static final int DEFAULT_MAX_RETRIES = 5;
    private final String customEndpoint;
    private final String customRegion;
    private Duration transmissionTimeout;
    private int maxRetries = 5;

    public Ec2ClientFactoryImpl(@Nullable String customEndpoint, @Nullable String customRegion) {
        this.customEndpoint = customEndpoint;
        this.customRegion = customRegion;
        Integer transmissionTimeoutSeconds = Integer.getInteger(EC2_TRANSMISSION_TIMEOUT_PROPERTY, 50);
        this.transmissionTimeout = Duration.ofSeconds(transmissionTimeoutSeconds.intValue());
    }

    public Ec2ClientFactoryImpl() {
        this(null, null);
    }

    @Override
    @NotNull
    public AmazonEC2Async newAmazonEc2Async(@NotNull AwsSupportConstants.Region region, @NotNull AWSCredentials awsCredentials, @NotNull ScheduledExecutorService scheduledExecutorService) {
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider(awsCredentials);
        return this.newAmazonEc2Async(region, (AWSCredentialsProvider)awsCredentialsProvider, scheduledExecutorService);
    }

    @Override
    public AmazonEC2Async newAmazonEc2Async(@NotNull AwsSupportConstants.Region region, @NotNull AWSCredentialsProvider awsCredentialsProvider, @NotNull ScheduledExecutorService scheduledExecutorService) {
        return this.newAwsAsyncClient(region, awsCredentialsProvider, scheduledExecutorService);
    }

    @VisibleForTesting
    AmazonEC2Async newAwsAsyncClient(@NotNull AwsSupportConstants.Region region, @NotNull AWSCredentialsProvider awsCredentialsProvider, @NotNull ScheduledExecutorService scheduledExecutorService) {
        int transmissionTimeoutMs = (int)this.transmissionTimeout.toMillis();
        ClientConfiguration clientConfiguration = HttpClientConfigurationUtilsDoNotUse.newClientConfiguration((int)transmissionTimeoutMs, (int)this.maxRetries);
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = this.getEndpointConfiguration(region);
        return (AmazonEC2Async)((AmazonEC2AsyncClientBuilder)((AmazonEC2AsyncClientBuilder)((AmazonEC2AsyncClientBuilder)((AmazonEC2AsyncClientBuilder)AmazonEC2AsyncClientBuilder.standard().withClientConfiguration(clientConfiguration)).withEndpointConfiguration(endpointConfiguration)).withCredentials(awsCredentialsProvider)).withExecutorFactory(() -> scheduledExecutorService)).build();
    }

    @VisibleForTesting
    AwsClientBuilder.EndpointConfiguration getEndpointConfiguration(@NotNull AwsSupportConstants.Region region) {
        if (region == AwsSupportConstants.Region.CUSTOM) {
            log.debug((Object)String.format("Using custom AWS region %s with endpoint %s", this.customRegion, this.customEndpoint));
            if (this.customEndpoint == null) {
                throw new IllegalArgumentException("Custom endpoint is not set");
            }
            if (this.customRegion == null) {
                throw new IllegalArgumentException("Custom region is not set");
            }
            return new AwsClientBuilder.EndpointConfiguration(this.customEndpoint, this.customRegion);
        }
        log.debug((Object)String.format("Using AWS region %s", region));
        return new AwsClientBuilder.EndpointConfiguration(region.getEndpoint(), region.getSdkRegion().getName());
    }

    public void setTransmissionTimeout(int transmissionTimeoutSeconds) {
        this.transmissionTimeout = Duration.ofSeconds(transmissionTimeoutSeconds);
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }
}

