/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.model;

import com.atlassian.aws.ec2.model.ResourceId;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpotRequestId
extends ResourceId<SpotRequestId> {
    public SpotRequestId(@NotNull String id) {
        super(id);
        Preconditions.checkArgument((boolean)SpotRequestId.isValid(id));
    }

    public static boolean isValid(@Nullable CharSequence id) {
        return StringUtils.startsWith((CharSequence)id, (CharSequence)"spot-");
    }

    public static SpotRequestId from(@NotNull String spotRequestId) {
        return new SpotRequestId(spotRequestId);
    }
}

