/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.caches;

import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.Image;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ImageCache {
    private final AmazonEC2Async ec2Client;
    private final ConcurrentMap<String, Image> cachedImages = Maps.newConcurrentMap();

    public ImageCache(AmazonEC2Async ec2Client) {
        this.ec2Client = ec2Client;
    }

    public List<Image> describeImages(String ... imageIds) {
        ArrayList<Image> allImages = new ArrayList<Image>();
        HashSet imagesToDescribe = Sets.newHashSet((Object[])imageIds);
        for (String imageId : imageIds) {
            Image image = (Image)this.cachedImages.get(imageId);
            if (image == null) continue;
            imagesToDescribe.remove(image.getImageId());
            allImages.add(image);
        }
        if (!imagesToDescribe.isEmpty() || imageIds.length == 0) {
            DescribeImagesRequest request = new DescribeImagesRequest().withImageIds((Collection)imagesToDescribe);
            List describedImages = this.ec2Client.describeImages(request).getImages();
            allImages.addAll(this.addToCache(describedImages));
        }
        return allImages;
    }

    private List<Image> addToCache(@NotNull List<Image> images) {
        ArrayList<Image> imagesFromCache = new ArrayList<Image>();
        for (Image image : images) {
            Image imageFromCache = this.cachedImages.putIfAbsent(image.getImageId(), image);
            imagesFromCache.add((Image)MoreObjects.firstNonNull((Object)imageFromCache, (Object)image));
        }
        return imagesFromCache;
    }
}

