/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2.awssdk;

import com.amazonaws.services.ec2.model.AccountAttribute;
import com.amazonaws.services.ec2.model.AccountAttributeValue;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Ec2AccountAttributes {
    private static final String DEFAULT_VPC_ID_USED_ON_CLASSIC_EC2 = "none";
    private static final Logger log = Logger.getLogger(Ec2AccountAttributes.class);

    private Ec2AccountAttributes() {
    }

    @NotNull
    public static String getDefaultVpc(Map<String, AccountAttribute> accountAttributes) {
        AccountAttribute accountAttribute = accountAttributes.get(AccountAttributes.DEFAULT_VPC.getName());
        if (accountAttribute == null) {
            return "";
        }
        String defaultVpcId = ((AccountAttributeValue)Iterables.getOnlyElement((Iterable)accountAttribute.getAttributeValues())).getAttributeValue();
        return Ec2AccountAttributes.isClassicEc2Account(defaultVpcId) ? "" : defaultVpcId;
    }

    private static boolean isClassicEc2Account(String defaultVpcId) {
        return defaultVpcId.equalsIgnoreCase(DEFAULT_VPC_ID_USED_ON_CLASSIC_EC2);
    }

    private static enum AccountAttributes implements AwsSupportConstants.NameProvider
    {
        DEFAULT_VPC("default-vpc"),
        SUPPORTED_PLATFORMS("supported-platforms");

        private final String name;

        private AccountAttributes(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

