/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.ec2;

import com.atlassian.aws.ec2.UpdateScheduler;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class UpdateSchedulerImpl
implements UpdateScheduler,
Runnable {
    private static final Logger log = Logger.getLogger(UpdateSchedulerImpl.class);
    private static final int DELAY = 30;
    private static final int INITIAL_DELAY = 0;
    private final Lock updateLock = new ReentrantLock();
    private final CopyOnWriteArrayList<Runnable> updateTasks = new CopyOnWriteArrayList();

    public UpdateSchedulerImpl(ScheduledExecutorService scheduledExecutorService) {
        scheduledExecutorService.scheduleWithFixedDelay(this, 0L, 30L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.updateLock.tryLock()) {
            try {
                for (Runnable runnable : this.updateTasks) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable e) {
                        log.error((Object)("Could not execute '" + runnable.getClass() + "'"), e);
                    }
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }
    }

    @Override
    public void addUpdateTask(Runnable runnable) {
        this.updateTasks.add(runnable);
    }
}

