/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.ig.n6;
import com.aspose.slides.internal.in.ek;
import com.aspose.slides.internal.in.r2;
import com.aspose.slides.internal.ph.ae;
import com.aspose.slides.internal.ph.e1;
import com.aspose.slides.internal.ph.ef;
import com.aspose.slides.internal.ph.el;
import com.aspose.slides.internal.ph.wj;
import com.aspose.slides.internal.uo.l0;
import com.aspose.slides.internal.uo.ql;
import com.aspose.slides.ms.System.g0;
import com.aspose.slides.ms.System.ic;
import com.aspose.slides.ms.System.qn;
import com.aspose.slides.ms.System.qu;
import com.aspose.slides.ms.System.u1;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@u1
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
e1,
el,
g0,
Map {
    private IGenericEqualityComparer l0;
    private final Object ql = new Object();
    private Bucket[] r2;
    private int ic;
    private volatile boolean yx;
    private ICollection ek;
    private float el;
    private int yw;
    private ae n6;
    private int e1;
    private ICollection as;
    private volatile int t9;
    private static final ek ap = new ek("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp2, Comparator comparer) {
        this(0, 1.0f, hcp2, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", qn.l0("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.el = 0.72f * loadFactor;
        double d = (float)capacity / this.el;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.uo.l0.l0((int)d) : 11;
        this.r2 = this.ql(n);
        this.yw = (int)(this.el * (float)n);
        this.yx = false;
    }

    protected Hashtable(ae info, wj context) {
        this.n6 = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp2, Comparator comparer) {
        this(d, 1.0f, hcp2, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp2, Comparator comparer) {
        this(capacity, 1.0f, hcp2, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.l0 = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp2, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp2, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp2, Comparator comparer) {
        this(capacity, loadFactor);
        this.l0 = hcp2 == null && comparer == null ? null : new CompatibleComparer(comparer, hcp2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.l0(key, value, true);
    }

    @Override
    public void clear() {
        if (this.ic != 0) {
            this.yx = true;
            for (int i = 0; i < this.r2.length; ++i) {
                this.r2[i].r2 = 0;
                this.r2[i].l0 = null;
                this.r2[i].ql = null;
            }
            this.ic = 0;
            this.e1 = 0;
            this.ic();
            this.yx = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.r2;
        Hashtable hashtable = new Hashtable(this.ic, this.l0);
        hashtable.t9 = this.t9;
        hashtable.el = this.el;
        hashtable.ic = 0;
        int n = this.r2.length;
        while (n > 0) {
            Object object = bucketArray[--n].l0;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].ql);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.r2;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.l0(key, this.r2.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.r2.length);
        do {
            bucketArray[n10].l0(bucket);
            if (bucket.l0 == null) {
                return false;
            }
            if ((long)(bucket.r2 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.l0, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.r2.length);
        } while (bucket.r2 < 0 && ++n < this.r2.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.r2.length;
            while (--n >= 0) {
                if (this.r2[n].l0 == null || this.r2[n].l0 == this.r2 || this.r2[n].ql != null) continue;
                return true;
            }
        } else {
            int n = this.r2.length;
            while (--n >= 0) {
                Object object = this.r2[n].ql;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void r2(ic ic2, int n) {
        Bucket[] bucketArray = this.r2;
        int n10 = this.r2.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].l0;
            if (object == null || object == this.r2) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].ql);
            ic2.r2(dictionaryEntry.Clone(), n++);
        }
    }

    void l0(ic ic2, int n) {
        Bucket[] bucketArray = this.r2;
        int n10 = this.r2.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].l0;
            if (object == null || object == this.r2) continue;
            ic2.r2(object, n++);
        }
    }

    @Override
    public void copyTo(ic array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.ic() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.yx() - arrayIndex < this.ic) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.r2(array, arrayIndex);
    }

    void ql(ic ic2, int n) {
        Bucket[] bucketArray = this.r2;
        int n10 = this.r2.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].l0;
            if (object == null || object == this.r2) continue;
            ic2.r2(bucketArray[n10].ql, n++);
        }
    }

    private void ql() {
        int n = com.aspose.slides.internal.uo.l0.l0(this.r2.length * 2);
        this.l0(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.l0 != null) {
            return this.l0.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(ae info, wj context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.l0("LoadFactor", this.el);
        info.l0("Version", this.t9);
        if (this.l0 == null) {
            info.l0("Comparer", null, com.aspose.slides.internal.in.r2.l0(Comparator.class));
            info.l0("HashCodeProvider", null, com.aspose.slides.internal.in.r2.l0(IHashCodeProvider.class));
        } else if (this.l0 instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.in.r2.l0(this.l0, CompatibleComparer.class);
            info.l0("Comparer", objectArray.l0(), com.aspose.slides.internal.in.r2.l0(Comparator.class));
            info.l0("HashCodeProvider", objectArray.ql(), com.aspose.slides.internal.in.r2.l0(IHashCodeProvider.class));
        } else {
            info.l0("KeyComparer", this.l0, com.aspose.slides.internal.in.r2.l0(IGenericEqualityComparer.class));
        }
        info.l0("HashSize", this.r2.length);
        objectArray = new Object[this.ic];
        Object[] objectArray2 = new Object[this.ic];
        this.l0(com.aspose.slides.ms.System.ic.l0(objectArray), 0);
        this.ql(com.aspose.slides.ms.System.ic.l0(objectArray2), 0);
        info.l0("Keys", objectArray, com.aspose.slides.internal.in.r2.l0(Object[].class));
        info.l0("Values", objectArray2, com.aspose.slides.internal.in.r2.l0(Object[].class));
    }

    private long l0(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void l0(Object object, Object object2, boolean bl2) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.ic >= this.yw) {
                this.ql();
            } else if (this.e1 > this.yw && this.ic > 100) {
                this.r2();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.l0(object, this.r2.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.r2.length);
            do {
                if (n10 == -1 && this.r2[n11].l0 == this.r2 && this.r2[n11].r2 < 0) {
                    n10 = n11;
                }
                if (this.r2[n11].l0 == null || this.r2[n11].l0 == this.r2 && ((long)this.r2[n11].r2 & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.yx = true;
                    this.r2[n11].ql = object2;
                    this.r2[n11].l0 = object;
                    this.r2[n11].r2 |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.ic;
                    this.ic();
                    this.yx = false;
                    break block12;
                }
                if ((long)(this.r2[n11].r2 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.r2[n11].l0, object)) {
                    if (bl2) {
                        throw new ArgumentException(qn.l0("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.r2[n11].l0, object));
                    }
                    this.yx = true;
                    this.r2[n11].ql = object2;
                    this.ic();
                    this.yx = false;
                    break block12;
                }
                if (n10 == -1 && this.r2[n11].r2 >= 0) {
                    this.r2[n11].r2 = (int)((long)this.r2[n11].r2 | Integer.MIN_VALUE);
                    ++this.e1;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.r2.length);
            } while (++n < this.r2.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.yx = true;
            this.r2[n10].ql = object2;
            this.r2[n10].l0 = object;
            this.r2[n10].r2 |= (int)(l11 & 0xFFFFFFFFL);
            ++this.ic;
            this.ic();
            this.yx = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (qu.ql(this.r2, item)) {
            return false;
        }
        if (this.l0 != null) {
            return this.l0.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.r2 == null) {
            if (this.n6 == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            ef ef2 = this.n6.ic();
            while (ef2.hasNext()) {
                switch (ap.l0(ef2.ql())) {
                    case 0: {
                        this.el = this.n6.ql("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.n6.l0("HashSize");
                        break;
                    }
                    case 2: {
                        this.l0 = (IGenericEqualityComparer)this.n6.l0("KeyComparer", com.aspose.slides.internal.in.r2.l0(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.n6.l0("Comparer", com.aspose.slides.internal.in.r2.l0(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.n6.l0("HashCodeProvider", com.aspose.slides.internal.in.r2.l0(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.n6.l0("Keys", com.aspose.slides.internal.in.r2.l0(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.n6.l0("Values", com.aspose.slides.internal.in.r2.l0(Object[].class));
                    }
                }
            }
            this.yw = (int)(this.el * (float)n);
            if (this.l0 == null && (comparator != null || iHashCodeProvider != null)) {
                this.l0 = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.r2 = this.ql(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.l0(objectArray[i], objectArray2[i], true);
            }
            this.t9 = this.n6.l0("Version");
            this.n6 = null;
        }
    }

    private void l0(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = n;
        long l10 = 1L + (((l & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].l0 == null || bucketArray[n10].l0 == this.r2) {
                bucketArray[n10].ql = object2;
                bucketArray[n10].l0 = object;
                bucketArray[n10].r2 |= n;
                break;
            }
            if (bucketArray[n10].r2 >= 0) {
                bucketArray[n10].r2 = (int)((long)bucketArray[n10].r2 | Integer.MIN_VALUE);
                ++this.e1;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void r2() {
        this.l0(this.r2.length);
    }

    private void l0(int n) {
        this.e1 = 0;
        Bucket[] bucketArray = this.ql(n);
        for (int i = 0; i < this.r2.length; ++i) {
            Bucket bucket = this.r2[i].l0();
            if (bucket.l0 == null || bucket.l0 == this.r2) continue;
            this.l0(bucketArray, bucket.l0, bucket.ql, bucket.r2 & Integer.MAX_VALUE);
        }
        this.yx = true;
        this.r2 = bucketArray;
        this.yw = (int)(this.el * (float)n);
        this.ic();
        this.yx = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.l0(key, this.r2.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.r2.length);
        do {
            this.r2[n10].l0(bucket);
            if ((long)(bucket.r2 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.l0, key)) {
                this.yx = true;
                this.r2[n10].r2 = (int)((long)this.r2[n10].r2 & Integer.MIN_VALUE);
                this.r2[n10].l0 = this.r2[n10].r2 != 0 ? this.r2 : null;
                this.r2[n10].ql = null;
                --this.ic;
                this.ic();
                this.yx = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.r2.length);
        } while (bucket.r2 < 0 && ++n < this.r2.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] l0() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.ic];
        int n = 0;
        Bucket[] bucketArray = this.r2;
        int n10 = this.r2.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].l0;
            if (object == null || object == this.r2) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].ql);
        }
        return keyValuePairsArray;
    }

    private void ic() {
        ++this.t9;
    }

    private Bucket[] ql(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.ic;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.l0;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.r2;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.l0(key, this.r2.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.r2.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.t9;
                bucketArray[n10].l0(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.ig.n6.ql(1);
            } while (this.yx || n11 != this.t9);
            if (bucket.l0 == null) break;
            if ((long)(bucket.r2 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.l0, key)) {
                return bucket.ql;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.r2.length);
        } while (bucket.r2 < 0 && ++n < this.r2.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.l0(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.ek == null) {
            this.ek = new KeyCollection(this);
        }
        return this.ek;
    }

    @Override
    public Object getSyncRoot() {
        return this.ql;
    }

    @Override
    public ICollection getValues() {
        if (this.as == null) {
            this.as = new ValueCollection(this);
        }
        return this.as;
    }

    @Override
    public boolean isEmpty() {
        return this.ic == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        ic ic2 = com.aspose.slides.ms.System.ic.l0(objectArray);
        this.getKeys().copyTo(ic2, 0);
        return new ReadOnlyItemCollection(ic2);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        ic ic2 = com.aspose.slides.ms.System.ic.l0(objectArray);
        this.getValues().copyTo(ic2, 0);
        return new ReadOnlyItemCollection(ic2);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.l0();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].l0(), keyValuePairsArray[i].ql());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.ic.l0(entryArray));
    }

    public int getVersion() {
        return this.t9;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new ql(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private ic ql;

        ReadOnlyItemCollection(ic items) {
            this.ql = items;
        }

        @Override
        public int size() {
            return this.ql.size();
        }

        @Override
        public boolean isEmpty() {
            return this.ql.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.ql.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.ql.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            ic ic2 = com.aspose.slides.ms.System.ic.l0(objectArray);
            this.ql.copyTo(ic2, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.ql.copyTo(com.aspose.slides.ms.System.ic.l0(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @u1
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable l0;

        SyncHashtable(Hashtable table) {
            super(false);
            this.l0 = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.l0.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.l0.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.l0.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ic array, int arrayIndex) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.l0.iterator();
        }

        @Override
        public void getObjectData(ae info, wj context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.l0("ParentTable", this.l0, com.aspose.slides.internal.in.r2.l0(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] l0() {
            return this.l0.l0();
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.l0.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.l0.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.l0.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                this.l0.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.l0.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.l0.getSyncRoot();
            synchronized (object) {
                return this.l0.getValues();
            }
        }
    }

    @u1
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable l0;

        ValueCollection(Hashtable hashtable) {
            this.l0 = hashtable;
        }

        @Override
        public void copyTo(ic array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.ic() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.yx() - arrayIndex < this.l0.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.l0.ql(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.l0, 2);
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.l0.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.l0.getSyncRoot();
        }
    }

    @u1
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable l0;

        KeyCollection(Hashtable hashtable) {
            this.l0 = hashtable;
        }

        @Override
        public void copyTo(ic array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.ic() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.yx() - arrayIndex < this.l0.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.l0.l0(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.l0, 1);
        }

        @Override
        public int size() {
            return this.l0.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.l0.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.l0.getSyncRoot();
        }
    }

    @u1
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int l0;
        private boolean ql;
        private Object r2;
        private Object ic;
        private int yx;
        private Hashtable ek;
        private int el;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.ek = hashtable;
            this.l0 = hashtable.r2.length;
            this.el = hashtable.t9;
            this.ql = false;
            this.yx = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.el != this.ek.t9) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.l0 > 0) {
                --this.l0;
                Object object = ((Hashtable)this.ek).r2[this.l0].l0;
                if (object == null || object == this.ek.r2) continue;
                this.r2 = object;
                this.ic = ((Hashtable)this.ek).r2[this.l0].ql;
                this.ql = true;
                return true;
            }
            this.ql = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.el != this.ek.t9) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.ql = false;
            this.l0 = this.ek.r2.length;
            this.r2 = null;
            this.ic = null;
        }

        @Override
        public Object next() {
            if (!this.ql) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.yx == 1) {
                return this.r2;
            }
            if (this.yx == 2) {
                return this.ic;
            }
            return new DictionaryEntry(this.r2, this.ic);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.ql) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.r2, this.ic);
        }

        @Override
        public Object getKey() {
            if (!this.ql) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.r2;
        }

        @Override
        public Object getValue() {
            if (!this.ql) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.ic;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object l0;
        private Object ql;

        public KeyValuePairs(Object key, Object value) {
            this.ql = value;
            this.l0 = key;
        }

        public Object l0() {
            return this.l0;
        }

        public Object ql() {
            return this.ql;
        }
    }

    private static class Bucket
    extends com.aspose.slides.internal.in.el<Bucket> {
        public Object l0;
        public Object ql;
        public int r2;

        public void l0(Bucket bucket) {
            bucket.l0 = this.l0;
            bucket.ql = this.ql;
            bucket.r2 = this.r2;
        }

        public Bucket l0() {
            Bucket bucket = new Bucket();
            this.l0(bucket);
            return bucket;
        }

        public Object clone() {
            return this.l0();
        }

        private boolean ql(Bucket bucket) {
            return qu.l0(bucket.l0, this.l0) && qu.l0(bucket.ql, this.ql) && bucket.r2 == this.r2;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (qu.ql(null, obj)) {
                return false;
            }
            if (qu.ql(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.ql((Bucket)obj);
        }

        public int hashCode() {
            int n = this.l0 != null ? this.l0.hashCode() : 0;
            n = 31 * n + (this.ql != null ? this.ql.hashCode() : 0);
            n = 31 * n + this.r2;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.l0();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.l0((Bucket)object);
        }
    }

    @u1
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator l0;
        private IHashCodeProvider ql;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.l0 = comparer;
            this.ql = hashCodeProvider;
        }

        public int l0(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.l0 != null) {
                return this.l0.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.in.r2.l0(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.l0(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.ql != null) {
                return this.ql.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator l0() {
            return this.l0;
        }

        IHashCodeProvider ql() {
            return this.ql;
        }
    }
}

