/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.v5;
import com.aspose.slides.ms.System.v8;
import com.aspose.slides.ms.System.wp;

@v5
public final class BitArray
implements ICollection,
wp {
    private int[] v2;
    private int hn;
    private int cl = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.hn = bits.hn;
        this.v2 = new int[(this.hn + 31) / 32];
        if (this.v2.length == 1) {
            this.v2[0] = bits.v2[0];
        } else {
            v8.v2(bits.v2, 0, this.v2, 0, this.v2.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.hn = values.length;
        this.v2 = new int[(this.hn + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.hn = bytes.length * 8;
        this.v2 = new int[(this.hn + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.v2(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.hn = n * 32;
        this.v2 = new int[n];
        v8.v2(values, 0, this.v2, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.hn = length;
        this.v2 = new int[(this.hn + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.v2.length; ++i) {
                this.v2[i] = -1;
            }
        }
    }

    private byte v2(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.v2[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void v2(int n, byte by2) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.v2[n12] = this.v2[n12] & ~(255 << n11);
        int n13 = n10;
        this.v2[n13] = this.v2[n13] | (by2 & 0xFF) << n11;
        ++this.cl;
    }

    private void hn(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.hn != this.hn) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.hn;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.hn;
    }

    public void setLength(int value) {
        if (this.hn == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.hn) {
            int n = (value + 31) / 32;
            int n10 = (this.hn + 31) / 32;
            if (n > this.v2.length) {
                int[] nArray = new int[n];
                v8.v2(this.v2, 0, nArray, 0, this.v2.length);
                this.v2 = nArray;
            } else {
                v8.v2(v8.v2((Object)this.v2), n10, n - n10);
            }
            int n11 = this.hn % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.v2[n12] = this.v2[n12] & (1 << n11) - 1;
            }
        }
        this.hn = value;
        ++this.cl;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(v8 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.v8() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.s0() && this.hn > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = v8.v2(array);
        if (object instanceof Boolean[]) {
            if (array.s0() - index < this.hn) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.hn; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.s0() - index < this.hn) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.hn; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.hn + 7) / 8;
            if (array.s0() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.v2(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.hn + 7) / 8;
            if (array.s0() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.v2(i);
            }
        } else if (object instanceof Integer[]) {
            v8.v2(v8.v2((Object)this.v2), 0, array, index, (this.hn + 31) / 32);
        } else if (object instanceof int[]) {
            v8.v2(v8.v2((Object)this.v2), 0, array, index, (this.hn + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.hn + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.v2[i] = ~this.v2[i];
        }
        ++this.cl;
        return this;
    }

    public BitArray and(BitArray value) {
        this.hn(value);
        int n = (this.hn + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.v2[n10] = this.v2[n10] & value.v2[i];
        }
        ++this.cl;
        return this;
    }

    public BitArray or(BitArray value) {
        this.hn(value);
        int n = (this.hn + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.v2[n10] = this.v2[n10] | value.v2[i];
        }
        ++this.cl;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.hn(value);
        int n = (this.hn + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.v2[n10] = this.v2[n10] ^ value.v2[i];
        }
        ++this.cl;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.hn) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.v2[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.hn) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.v2[n] = this.v2[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.v2[n] = this.v2[n] & ~(1 << (index & 0x1F));
        }
        ++this.cl;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.v2.length; ++i) {
                this.v2[i] = -1;
            }
        } else {
            v8.v2(v8.v2((Object)this.v2), 0, this.v2.length);
        }
        ++this.cl;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @v5
    private static class BitArrayEnumerator
    implements IEnumerator,
    wp,
    Cloneable {
        private BitArray v2;
        private boolean hn;
        private int cl;
        private int v8;

        @Override
        public Object deepClone() {
            return this.v2();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.cl = -1;
            this.v2 = ba2;
            this.v8 = ba2.cl;
        }

        @Override
        public Object next() {
            if (this.cl == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.cl >= this.v2.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.hn;
        }

        @Override
        public boolean hasNext() {
            this.hn();
            if (this.cl < this.v2.size() - 1) {
                this.hn = this.v2.get_Item(++this.cl);
                return true;
            }
            this.cl = this.v2.size();
            return false;
        }

        @Override
        public void reset() {
            this.hn();
            this.cl = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void hn() {
            if (this.v8 != this.v2.cl) {
                throw new InvalidOperationException();
            }
        }

        protected Object v2() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.v2 = this.v2;
            bitArrayEnumerator.hn = this.hn;
            bitArrayEnumerator.cl = this.cl;
            bitArrayEnumerator.v8 = this.v8;
            return bitArrayEnumerator;
        }
    }
}

