/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.MethodInlinerUtilKt;
import org.jetbrains.kotlin.codegen.optimization.common.InstructionLivenessAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/DeadCodeEliminationMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "shouldRemove", "", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "index", "", "liveness", "", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "backend"})
public final class DeadCodeEliminationMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        boolean[] liveness = new InstructionLivenessAnalyzer(methodNode, false, 2, null).analyze();
        ArrayList<AbstractInsnNode> insnsToRemove = new ArrayList<AbstractInsnNode>();
        AbstractInsnNode[] insns = methodNode.instructions.toArray();
        int n = insns.length;
        for (int i2 = 0; i2 < n; ++i2) {
            AbstractInsnNode insn = insns[i2];
            Intrinsics.checkNotNullExpressionValue((Object)insn, (String)"insn");
            if (!this.shouldRemove(insn, i2, liveness)) continue;
            insnsToRemove.add(insn);
        }
        MethodInlinerUtilKt.remove(methodNode, (Collection<? extends AbstractInsnNode>)insnsToRemove);
        UtilKt.removeEmptyCatchBlocks(methodNode);
        UtilKt.removeUnusedLocalVariables(methodNode);
    }

    private final boolean shouldRemove(AbstractInsnNode insn, int index2, boolean[] liveness) {
        if (!(insn instanceof LineNumberNode)) {
            return !liveness[index2];
        }
        AbstractInsnNode finger = insn;
        int fingerIndex = index2;
        boolean hasDeadInsn = false;
        while (finger.getNext() != null) {
            ++fingerIndex;
            AbstractInsnNode abstractInsnNode = finger;
            if (abstractInsnNode instanceof LabelNode) continue;
            if (abstractInsnNode instanceof LineNumberNode) {
                if (((LineNumberNode)finger).line == ((LineNumberNode)insn).line) continue;
                return hasDeadInsn;
            }
            if (liveness[fingerIndex]) {
                return false;
            }
            hasDeadInsn = true;
        }
        return true;
    }
}

