/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal;

import com.android.ddmlib.AdbHelper;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class AdbSocketUtils {
    static void read(SocketChannel socket, ByteBuffer buf) throws IOException {
        while (buf.remaining() > 0) {
            int count = socket.read(buf);
            if (count >= 0) continue;
            throw new EOFException("EOF");
        }
    }

    static String read(SocketChannel socket, byte[] buffer) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(buffer, 0, buffer.length);
        AdbSocketUtils.read(socket, buf);
        return new String(buffer, 0, buf.position(), AdbHelper.DEFAULT_CHARSET);
    }

    static int readLength(SocketChannel socket, byte[] buffer) throws IOException {
        String msg = AdbSocketUtils.read(socket, buffer);
        if (msg != null) {
            try {
                return Integer.parseInt(msg, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IOException("Unable to read length");
    }
}

