/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.TokenizedCommandLine;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\b\u0006\u001a.\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000b\u001a:\u0010\u0005\u001a\u00020\f\"\u0004\b\u0000\u0010\u00072\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000b\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a%\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\u001a\u0010\u0019\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u0006\u001a#\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0016\"\u00020\u0006\u00a2\u0006\u0002\u0010\u001d\u001a\u0012\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u001a\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006\u001a\u001a\u0010\u001b\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u0012\u0010 \u001a\u00020\u0006*\u00020\u00062\u0006\u0010!\u001a\u00020\u0006\u001a\u0010\u0010\u0005\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00060\"\u001a\n\u0010#\u001a\u00020\u0006*\u00020\u0006\u001a\u0010\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014*\u00020\u0006\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014*\u00020\u0006\u001a\n\u0010&\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010'\u001a\u00020\u0006*\u00020\u0006\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"CR", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "LF", "Ljava/util/regex/Pattern;", "combineAsCamelCase", "", "T", "objectList", "", "mapFunction", "Lkotlin/Function1;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toLineSeparator", "separator", "input", "toStrings", "", "objects", "", "", "([Ljava/lang/Object;)Ljava/util/List;", "appendCamelCase", "word", "appendCapitalized", "words", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "word1", "word2", "capitalizeAndAppend", "suffix", "", "toSystemLineSeparator", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "usLocaleCapitalize", "usLocaleDecapitalize", "common"})
@JvmName(name="StringHelper")
public final class StringHelper {
    private static final CharMatcher CR = CharMatcher.is((char)'\r');
    private static final Pattern LF = Pattern.compile("\n", 16);

    @NotNull
    public static final StringBuilder appendCapitalized(@NotNull StringBuilder $this$appendCapitalized, @NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)$this$appendCapitalized, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (((CharSequence)word).length() == 0) {
            return $this$appendCapitalized;
        }
        int c = word.charAt(0);
        if (c >= 55296 && c <= 56319) {
            c = word.codePointAt(0);
            int charCount = Character.charCount(c);
            String string = word.substring(0, charCount);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = string;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
            String upperString = string3;
            $this$appendCapitalized.append(upperString);
            $this$appendCapitalized.append(word, charCount, word.length());
        } else {
            char c2;
            int result = Character.toUpperCase(c);
            char upperChar = '\u0000';
            if (result != -1) {
                c2 = (char)result;
            } else {
                String string = word.substring(0, 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string4 = string;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string5 = string4.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toUpperCase(locale)");
                c2 = string5.charAt(0);
            }
            upperChar = c2;
            $this$appendCapitalized.append(upperChar);
            $this$appendCapitalized.append(word, 1, word.length());
        }
        return $this$appendCapitalized;
    }

    @NotNull
    public static final String usLocaleCapitalize(@NotNull String $this$usLocaleCapitalize) {
        Intrinsics.checkNotNullParameter((Object)$this$usLocaleCapitalize, (String)"<this>");
        StringBuilder sb = new StringBuilder($this$usLocaleCapitalize.length());
        StringHelper.appendCapitalized(sb, $this$usLocaleCapitalize);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String usLocaleDecapitalize(@NotNull String $this$usLocaleDecapitalize) {
        Intrinsics.checkNotNullParameter((Object)$this$usLocaleDecapitalize, (String)"<this>");
        if (((CharSequence)$this$usLocaleDecapitalize).length() == 0) {
            return $this$usLocaleDecapitalize;
        }
        StringBuilder sb = new StringBuilder($this$usLocaleDecapitalize.length());
        String string = $this$usLocaleDecapitalize.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String string2 = string;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        sb.append(string3);
        String string4 = $this$usLocaleDecapitalize.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        sb.append(string4);
        String string5 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"sb.toString()");
        return string5;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, @NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)$this$appendCapitalized, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        StringBuilder sb = new StringBuilder($this$appendCapitalized.length() + word.length());
        sb.append($this$appendCapitalized);
        StringHelper.appendCapitalized(sb, word);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, @NotNull String word1, @NotNull String word2) {
        Intrinsics.checkNotNullParameter((Object)$this$appendCapitalized, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)word1, (String)"word1");
        Intrinsics.checkNotNullParameter((Object)word2, (String)"word2");
        StringBuilder sb = new StringBuilder($this$appendCapitalized.length() + word1.length() + word2.length());
        sb.append($this$appendCapitalized);
        StringHelper.appendCapitalized(sb, word1);
        StringHelper.appendCapitalized(sb, word2);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, String ... words) {
        Intrinsics.checkNotNullParameter((Object)$this$appendCapitalized, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        int length = $this$appendCapitalized.length();
        int max = words.length;
        for (int i = 0; i < max; ++i) {
            length += words[i].length();
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append($this$appendCapitalized);
        for (String word : words) {
            StringHelper.appendCapitalized(sb, word);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String capitalizeAndAppend(@NotNull String $this$capitalizeAndAppend, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)$this$capitalizeAndAppend, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        StringBuilder sb = new StringBuilder($this$capitalizeAndAppend.length() + suffix.length());
        StringHelper.appendCapitalized(sb, $this$capitalizeAndAppend);
        sb.append(suffix);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final StringBuilder appendCamelCase(@NotNull StringBuilder $this$appendCamelCase, @NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)$this$appendCamelCase, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (((CharSequence)$this$appendCamelCase).length() == 0) {
            $this$appendCamelCase.append(word);
        } else {
            StringHelper.appendCapitalized($this$appendCamelCase, word);
        }
        return $this$appendCamelCase;
    }

    @NotNull
    public static final String combineAsCamelCase(@NotNull Iterable<String> $this$combineAsCamelCase) {
        Intrinsics.checkNotNullParameter($this$combineAsCamelCase, (String)"<this>");
        int count = 0;
        for (String s : $this$combineAsCamelCase) {
            count += s.length();
        }
        StringBuilder sb = new StringBuilder(count);
        boolean first = true;
        for (String str : $this$combineAsCamelCase) {
            if (first) {
                sb.append(str);
                first = false;
                continue;
            }
            StringHelper.appendCapitalized(sb, str);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final <T> String combineAsCamelCase(@NotNull Collection<? extends T> objectList, @NotNull Function1<? super T, String> mapFunction) {
        Intrinsics.checkNotNullParameter(objectList, (String)"objectList");
        Intrinsics.checkNotNullParameter(mapFunction, (String)"mapFunction");
        StringBuilder sb = new StringBuilder(objectList.size() * 20);
        StringHelper.combineAsCamelCase(sb, objectList, mapFunction);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static final <T> void combineAsCamelCase(@NotNull StringBuilder sb, @NotNull Collection<? extends T> objectList, @NotNull Function1<? super T, String> mapFunction) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Intrinsics.checkNotNullParameter(objectList, (String)"objectList");
        Intrinsics.checkNotNullParameter(mapFunction, (String)"mapFunction");
        boolean first = true;
        for (T obj : objectList) {
            if (first) {
                sb.append((String)mapFunction.invoke(obj));
                first = false;
                continue;
            }
            StringHelper.appendCapitalized(sb, (String)mapFunction.invoke(obj));
        }
    }

    @NotNull
    public static final List<String> toStrings(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object path : objects) {
            if (path instanceof String) {
                builder.add(path);
                continue;
            }
            if (path instanceof Collection) {
                for (Object item : (Collection)path) {
                    if (item instanceof String) {
                        builder.add(item);
                        continue;
                    }
                    builder.add((Object)path.toString());
                }
                continue;
            }
            builder.add((Object)path.toString());
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"builder.build()");
        return (List)immutableList;
    }

    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String $this$tokenizeCommandLineToEscaped) {
        Intrinsics.checkNotNullParameter((Object)$this$tokenizeCommandLineToEscaped, (String)"<this>");
        return new TokenizedCommandLine($this$tokenizeCommandLineToEscaped, false, 0, null, 12, null).toTokenList();
    }

    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String $this$tokenizeCommandLineToRaw) {
        Intrinsics.checkNotNullParameter((Object)$this$tokenizeCommandLineToRaw, (String)"<this>");
        return new TokenizedCommandLine($this$tokenizeCommandLineToRaw, true, 0, null, 12, null).toTokenList();
    }

    @NotNull
    public static final String toSystemLineSeparator(@NotNull String $this$toSystemLineSeparator) {
        Intrinsics.checkNotNullParameter((Object)$this$toSystemLineSeparator, (String)"<this>");
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        return StringHelper.toLineSeparator(string, $this$toSystemLineSeparator);
    }

    private static final String toLineSeparator(String separator, String input) {
        String string;
        String unixStyle;
        String string2 = unixStyle = CR.matchesAnyOf((CharSequence)input) ? CR.removeFrom((CharSequence)input) : input;
        if (Intrinsics.areEqual((Object)separator, (Object)"\n")) {
            Intrinsics.checkNotNullExpressionValue((Object)unixStyle, (String)"unixStyle");
            string = unixStyle;
        } else {
            String string3 = LF.matcher(unixStyle).replaceAll("\r\n");
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"LF.matcher(unixStyle).replaceAll(\"\\r\\n\")");
        }
        return string;
    }
}

