/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.GenerateLibraryProguardRulesTask;
import com.android.build.gradle.internal.tasks.GenerateLibraryProguardRulesTaskKt;
import com.android.build.gradle.internal.tasks.NewIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.IncrementalChangesUtils;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.files.SerializableChange;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.OPTIMIZATION)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask;", "Lcom/android/build/gradle/internal/tasks/NewIncrementalTask;", "()V", "inputResourcesDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputResourcesDir", "()Lorg/gradle/api/file/DirectoryProperty;", "manifestFile", "Lorg/gradle/api/file/RegularFileProperty;", "getManifestFile", "()Lorg/gradle/api/file/RegularFileProperty;", "proguardOutputFile", "getProguardOutputFile", "doTaskAction", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "CreationAction", "GenerateProguardRulesWorkAction", "gradle-core"})
public abstract class GenerateLibraryProguardRulesTask
extends NewIncrementalTask {
    @OutputFile
    @NotNull
    public abstract RegularFileProperty getProguardOutputFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getManifestFile();

    @Incremental
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getInputResourcesDir();

    @Override
    public void doTaskAction(@NotNull InputChanges inputChanges) {
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        boolean isIncremental = inputChanges.isIncremental();
        File manifest = ((RegularFile)this.getManifestFile().get()).getAsFile();
        if (!manifest.exists()) {
            throw new RuntimeException("Cannot find manifest file");
        }
        Collection changedResources = isIncremental ? IncrementalChangesUtils.getChangesInSerializableForm(inputChanges, (Provider<? extends FileSystemLocation>)((Provider)this.getInputResourcesDir())).getChanges() : (Collection)CollectionsKt.emptyList();
        this.getWorkerExecutor().noIsolation().submit(GenerateProguardRulesWorkAction.class, new Action(this, manifest, changedResources, inputChanges){
            final /* synthetic */ GenerateLibraryProguardRulesTask this$0;
            final /* synthetic */ File $manifest;
            final /* synthetic */ Collection<SerializableChange> $changedResources;
            final /* synthetic */ InputChanges $inputChanges;
            {
                this.this$0 = $receiver;
                this.$manifest = $manifest;
                this.$changedResources = $changedResources;
                this.$inputChanges = $inputChanges;
            }

            public final void execute(GenerateProguardRulesWorkAction.Params it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                it.getManifestFile().set(this.$manifest);
                it.getProguardOutputFile().set((Provider)this.this$0.getProguardOutputFile());
                it.getInputResourcesDir().set((Provider)this.this$0.getInputResourcesDir());
                it.getChangedResources().set((Iterable)this.$changedResources);
                it.getIncremental().set((Object)this.$inputChanges.isIncremental());
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateLibraryProguardRulesTask, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("generate", "LibraryProguardRules");
        }

        @Override
        @NotNull
        public Class<GenerateLibraryProguardRulesTask> getType() {
            return GenerateLibraryProguardRulesTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<GenerateLibraryProguardRulesTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("aapt_rules.txt").on(InternalArtifactType.AAPT_PROGUARD_FILE.INSTANCE);
        }

        @Override
        public void configure(@NotNull GenerateLibraryProguardRulesTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            this.creationConfig.getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.PACKAGED_RES.INSTANCE, (Property)task.getInputResourcesDir());
            this.creationConfig.getArtifacts().setTaskInputToFinalProduct((Artifact.Single)SingleArtifact.MERGED_MANIFEST.INSTANCE, (Property)task.getManifestFile());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$GenerateProguardRulesWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$GenerateProguardRulesWorkAction$Params;", "()V", "canBeProcessedIncrementally", "", "params", "run", "", "Params", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nGenerateLibraryProguardRulesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateLibraryProguardRulesTask.kt\ncom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$GenerateProguardRulesWorkAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1726#2,3:209\n*S KotlinDebug\n*F\n+ 1 GenerateLibraryProguardRulesTask.kt\ncom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$GenerateProguardRulesWorkAction\n*L\n117#1:209,3\n*E\n"})
    public static abstract class GenerateProguardRulesWorkAction
    extends ProfileAwareWorkAction<Params> {
        @Override
        public void run() {
            WorkParameters workParameters = this.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)workParameters, (String)"getParameters(...)");
            if (this.canBeProcessedIncrementally((Params)workParameters)) {
                WorkParameters workParameters2 = this.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)workParameters2, (String)"getParameters(...)");
                GenerateLibraryProguardRulesTaskKt.runIncrementalTask((Params)workParameters2);
                return;
            }
            WorkParameters workParameters3 = this.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)workParameters3, (String)"getParameters(...)");
            GenerateLibraryProguardRulesTaskKt.runFullTask((Params)workParameters3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean canBeProcessedIncrementally(Params params) {
            boolean bl;
            Object object = params.getChangedResources().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            Iterable $this$all$iv = (Iterable)object;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    SerializableChange it = (SerializableChange)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (GenerateLibraryProguardRulesTaskKt.canResourcesBeProcessedIncrementally(it)) continue;
                    return false;
                }
                bl = true;
            }
            if (!bl) return false;
            Object object2 = params.getIncremental().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            if ((Boolean)object2 == false) return false;
            return true;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$GenerateProguardRulesWorkAction$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "changedResources", "Lorg/gradle/api/provider/ListProperty;", "Lcom/android/builder/files/SerializableChange;", "getChangedResources", "()Lorg/gradle/api/provider/ListProperty;", "incremental", "Lorg/gradle/api/provider/Property;", "", "getIncremental", "()Lorg/gradle/api/provider/Property;", "inputResourcesDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputResourcesDir", "()Lorg/gradle/api/file/DirectoryProperty;", "manifestFile", "Lorg/gradle/api/file/RegularFileProperty;", "getManifestFile", "()Lorg/gradle/api/file/RegularFileProperty;", "proguardOutputFile", "getProguardOutputFile", "gradle-core"})
        public static abstract class Params
        extends ProfileAwareWorkAction.Parameters {
            @NotNull
            public abstract RegularFileProperty getManifestFile();

            @NotNull
            public abstract RegularFileProperty getProguardOutputFile();

            @NotNull
            public abstract DirectoryProperty getInputResourcesDir();

            @NotNull
            public abstract ListProperty<SerializableChange> getChangedResources();

            @NotNull
            public abstract Property<Boolean> getIncremental();
        }
    }
}

