/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.Version;
import com.android.build.api.transform.Transform;
import com.android.build.api.variant.AndroidVersion;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.scope.Java8LangSupport;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.TestOptions;
import com.android.resources.Density;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.build.gradle.internal.profile.GradleTaskExecutionType;
import com.android.tools.build.gradle.internal.profile.GradleTransformExecutionType;
import com.android.tools.build.gradle.internal.profile.IntegerOption;
import com.android.tools.build.gradle.internal.profile.ModulePropertyKeys;
import com.android.tools.build.gradle.internal.profile.OptionalBooleanOption;
import com.android.tools.build.gradle.internal.profile.VariantApiArtifactType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.wireless.android.sdk.stats.ApiVersion;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildSplits;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleIntegerOptionEntry;
import com.google.wireless.android.sdk.stats.GradleProjectOptionsSettings;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.google.wireless.android.sdk.stats.TestRun;
import java.lang.reflect.Method;
import java.util.Locale;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class AnalyticsUtil {
    public static ProductDetails getProductDetails() {
        return ProductDetails.newBuilder().setProduct(ProductDetails.ProductKind.GRADLE).setVersion(Version.ANDROID_GRADLE_PLUGIN_VERSION).setOsArchitecture(CommonMetricsData.getOsArchitecture()).build();
    }

    public static GradleTransformExecutionType getTransformType(Class<? extends Transform> taskClass) {
        Descriptors.EnumValueDescriptor value = GradleTransformExecutionType.getDescriptor().findValueByName(AnalyticsUtil.getPotentialTransformTypeName(taskClass));
        if (value == null) {
            return GradleTransformExecutionType.UNKNOWN_TRANSFORM_TYPE;
        }
        return GradleTransformExecutionType.valueOf((Descriptors.EnumValueDescriptor)value);
    }

    @VisibleForTesting
    static String getPotentialTransformTypeName(Class<?> taskClass) {
        String taskImpl = taskClass.getSimpleName();
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, taskImpl);
    }

    public static GradleTaskExecutionType getTaskExecutionType(Class<?> taskClass) {
        Descriptors.EnumValueDescriptor value = GradleTaskExecutionType.getDescriptor().findValueByName(AnalyticsUtil.getPotentialTaskExecutionTypeName(taskClass));
        if (value == null) {
            return GradleTaskExecutionType.UNKNOWN_TASK_TYPE;
        }
        return GradleTaskExecutionType.valueOf((Descriptors.EnumValueDescriptor)value);
    }

    public static VariantApiArtifactType getVariantApiArtifactType(Class<?> artifactType) {
        Descriptors.EnumValueDescriptor value = VariantApiArtifactType.getDescriptor().findValueByName(artifactType.getSimpleName());
        if (value == null) {
            return VariantApiArtifactType.CUSTOM_ARTIFACT_TYPE;
        }
        return VariantApiArtifactType.valueOf((Descriptors.EnumValueDescriptor)value);
    }

    static String getPotentialTaskExecutionTypeName(Class<?> taskClass) {
        String taskImpl = taskClass.getSimpleName();
        if (taskImpl.endsWith("_Decorated")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "_Decorated".length());
        }
        if (taskImpl.endsWith("Task")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "Task".length());
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, taskImpl);
    }

    public static com.google.wireless.android.sdk.stats.ApiVersion toProto(AndroidVersion apiVersion) {
        ApiVersion.Builder builder = com.google.wireless.android.sdk.stats.ApiVersion.newBuilder().setApiLevel((long)apiVersion.getApiLevel());
        if (apiVersion.getCodename() != null) {
            builder.setCodename(apiVersion.getCodename());
        }
        return builder.build();
    }

    public static com.google.wireless.android.sdk.stats.ApiVersion toProto(ApiVersion apiVersion) {
        ApiVersion.Builder builder = com.google.wireless.android.sdk.stats.ApiVersion.newBuilder().setApiLevel((long)apiVersion.getApiLevel());
        if (apiVersion.getCodename() != null) {
            builder.setCodename(apiVersion.getCodename());
        }
        return builder.build();
    }

    public static GradleBuildSplits toProto(Splits splits) {
        GradleBuildSplits.Builder builder = GradleBuildSplits.newBuilder();
        if (splits.getDensity().isEnable()) {
            builder.setDensityEnabled(true);
            for (String compatibleScreen : splits.getDensity().getCompatibleScreens()) {
                builder.addDensityCompatibleScreens(AnalyticsUtil.getCompatibleScreen(compatibleScreen));
            }
            for (String filter2 : splits.getDensity().getApplicableFilters()) {
                Density density = Density.getEnum((String)filter2);
                builder.addDensityValues(density == null ? -1 : density.getDpiValue());
            }
        }
        if (splits.getLanguage().isEnable()) {
            builder.setLanguageEnabled(true);
            for (String split : splits.getLanguage().getApplicationFilters()) {
                builder.addLanguageIncludes(split != null ? split : "null");
            }
        }
        if (splits.getAbi().isEnable()) {
            builder.setAbiEnabled(true);
            builder.setAbiEnableUniversalApk(splits.getAbi().isUniversalApk());
            for (String filter2 : splits.getAbi().getApplicableFilters()) {
                builder.addAbiFilters(AnalyticsUtil.getAbi(filter2));
            }
        }
        return builder.build();
    }

    public static GradleBuildVariant.Java8LangSupport toProto(Java8LangSupport type) {
        Preconditions.checkArgument((type != Java8LangSupport.UNUSED && type != Java8LangSupport.INVALID ? 1 : 0) != 0, (Object)"Unsupported type");
        switch (type) {
            case RETROLAMBDA: {
                return GradleBuildVariant.Java8LangSupport.RETROLAMBDA;
            }
            case R8: {
                return GradleBuildVariant.Java8LangSupport.R8_DESUGARING;
            }
            case D8: {
                return GradleBuildVariant.Java8LangSupport.D8;
            }
            case INVALID: 
            case UNUSED: {
                throw new IllegalArgumentException("Unexpected type " + type);
            }
        }
        throw new AssertionError((Object)("Unrecognized type " + type));
    }

    public static TestRun.TestExecution toProto(TestOptions.Execution execution) {
        switch (execution) {
            case HOST: {
                return TestRun.TestExecution.HOST;
            }
            case ANDROID_TEST_ORCHESTRATOR: 
            case ANDROIDX_TEST_ORCHESTRATOR: {
                return TestRun.TestExecution.ANDROID_TEST_ORCHESTRATOR;
            }
        }
        throw new AssertionError((Object)("Unrecognized type " + execution));
    }

    public static DeviceInfo.ApplicationBinaryInterface getAbi(String name) {
        Abi abi = Abi.getByName(name);
        if (abi == null) {
            return DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
        }
        switch (abi) {
            case ARMEABI: {
                return DeviceInfo.ApplicationBinaryInterface.ARME_ABI;
            }
            case ARMEABI_V7A: {
                return DeviceInfo.ApplicationBinaryInterface.ARME_ABI_V7A;
            }
            case ARM64_V8A: {
                return DeviceInfo.ApplicationBinaryInterface.ARM64_V8A_ABI;
            }
            case X86: {
                return DeviceInfo.ApplicationBinaryInterface.X86_ABI;
            }
            case X86_64: {
                return DeviceInfo.ApplicationBinaryInterface.X86_64_ABI;
            }
            case MIPS: {
                return DeviceInfo.ApplicationBinaryInterface.MIPS_ABI;
            }
            case MIPS64: {
                return DeviceInfo.ApplicationBinaryInterface.MIPS_R2_ABI;
            }
        }
        return DeviceInfo.ApplicationBinaryInterface.UNKNOWN_ABI;
    }

    private static GradleBuildSplits.CompatibleScreenSize getCompatibleScreen(String compatibleScreen) {
        switch (compatibleScreen.toLowerCase(Locale.US)) {
            case "small": {
                return GradleBuildSplits.CompatibleScreenSize.SMALL;
            }
            case "normal": {
                return GradleBuildSplits.CompatibleScreenSize.NORMAL;
            }
            case "large": {
                return GradleBuildSplits.CompatibleScreenSize.LARGE;
            }
            case "xlarge": {
                return GradleBuildSplits.CompatibleScreenSize.XLARGE;
            }
        }
        return GradleBuildSplits.CompatibleScreenSize.UNKNOWN_SCREEN_SIZE;
    }

    @VisibleForTesting
    static com.android.tools.build.gradle.internal.profile.BooleanOption toProto(BooleanOption option) {
        Descriptors.EnumValueDescriptor value = com.android.tools.build.gradle.internal.profile.BooleanOption.getDescriptor().findValueByName(option.name());
        if (value == null) {
            return com.android.tools.build.gradle.internal.profile.BooleanOption.UNKNOWN_BOOLEAN_OPTION;
        }
        return com.android.tools.build.gradle.internal.profile.BooleanOption.valueOf((Descriptors.EnumValueDescriptor)value);
    }

    @VisibleForTesting
    static OptionalBooleanOption toProto(com.android.build.gradle.options.OptionalBooleanOption option) {
        Descriptors.EnumValueDescriptor value = OptionalBooleanOption.getDescriptor().findValueByName(option.name());
        if (value == null) {
            return OptionalBooleanOption.UNKNOWN_OPTIONAL_BOOLEAN_OPTION;
        }
        return OptionalBooleanOption.valueOf((Descriptors.EnumValueDescriptor)value);
    }

    @VisibleForTesting
    static IntegerOption toProto(com.android.build.gradle.options.IntegerOption option) {
        Descriptors.EnumValueDescriptor value = IntegerOption.getDescriptor().findValueByName(option.name());
        if (value == null) {
            return IntegerOption.UNKNOWN_INTEGER_OPTION;
        }
        return IntegerOption.valueOf((Descriptors.EnumValueDescriptor)value);
    }

    @VisibleForTesting
    static com.android.tools.build.gradle.internal.profile.StringOption toProto(StringOption option) {
        Descriptors.EnumValueDescriptor value = com.android.tools.build.gradle.internal.profile.StringOption.getDescriptor().findValueByName(option.name());
        if (value == null) {
            return com.android.tools.build.gradle.internal.profile.StringOption.UNKNOWN_STRING_OPTION;
        }
        return com.android.tools.build.gradle.internal.profile.StringOption.valueOf((Descriptors.EnumValueDescriptor)value);
    }

    @VisibleForTesting
    public static ModulePropertyKeys toProto(String modulePropertyKey) {
        String modulePropertyKeyPrefix = "MODULE_";
        Descriptors.EnumValueDescriptor value = ModulePropertyKeys.getDescriptor().findValueByName("MODULE_" + modulePropertyKey);
        if (value == null) {
            return ModulePropertyKeys.UNKNOWN_MODULE_PROPERTY_KEY;
        }
        return ModulePropertyKeys.valueOf((Descriptors.EnumValueDescriptor)value);
    }

    public static GradleProjectOptionsSettings toProto(ProjectOptions projectOptions) {
        GradleProjectOptionsSettings.Builder builder = GradleProjectOptionsSettings.newBuilder();
        projectOptions.getExplicitlySetBooleanOptions().forEach((option, value) -> {
            if (value.booleanValue()) {
                builder.addTrueBooleanOptions(AnalyticsUtil.toProto(option).getNumber());
            } else {
                builder.addFalseBooleanOptions(AnalyticsUtil.toProto(option).getNumber());
            }
        });
        projectOptions.getExplicitlySetOptionalBooleanOptions().forEach((option, value) -> {
            if (value.booleanValue()) {
                builder.addTrueOptionalBooleanOptions(AnalyticsUtil.toProto(option).getNumber());
            } else {
                builder.addFalseOptionalBooleanOptions(AnalyticsUtil.toProto(option).getNumber());
            }
        });
        projectOptions.getExplicitlySetIntegerOptions().forEach((option, value) -> builder.addIntegerOptionValues(GradleIntegerOptionEntry.newBuilder().setIntegerOption(AnalyticsUtil.toProto(option).getNumber()).setIntegerOptionValue(value.intValue())));
        for (StringOption stringOption : projectOptions.getExplicitlySetStringOptions().keySet()) {
            builder.addStringOptions(AnalyticsUtil.toProto(stringOption).getNumber());
        }
        return builder.build();
    }

    public static GradleBuildProject.GradlePlugin toProto(Plugin<?> plugin) {
        return AnalyticsUtil.otherPluginToProto(plugin.getClass().getName());
    }

    @VisibleForTesting
    static GradleBuildProject.GradlePlugin otherPluginToProto(String pluginClassName) {
        String enumName = AnalyticsUtil.getOtherPluginEnumName(pluginClassName);
        Descriptors.EnumValueDescriptor value = GradleBuildProject.GradlePlugin.getDescriptor().findValueByName(enumName);
        if (value == null) {
            return GradleBuildProject.GradlePlugin.UNKNOWN_GRADLE_PLUGIN;
        }
        return GradleBuildProject.GradlePlugin.valueOf((Descriptors.EnumValueDescriptor)value);
    }

    @VisibleForTesting
    static String getOtherPluginEnumName(String pluginClassName) {
        String suffix;
        String name = pluginClassName.replace(".", "_");
        if (name.endsWith(suffix = "$Inject")) {
            name = name.substring(0, name.length() - suffix.length());
        }
        return name.toUpperCase(Locale.US);
    }

    public static void recordFirebasePerformancePluginVersion(Project project) {
        String version = AnalyticsUtil.getFirebasePerformancePluginVersion(project);
        if (version == null) {
            return;
        }
        GradleBuildProject.Builder projectBuilder = ((AnalyticsConfiguratorService)BuildServicesKt.getBuildService(project.getGradle().getSharedServices(), AnalyticsConfiguratorService.class).get()).getProjectBuilder(project.getPath());
        if (projectBuilder != null) {
            projectBuilder.setFirebasePerformancePluginVersion(version);
        }
    }

    private static String getFirebasePerformancePluginVersion(Project project) {
        Plugin plugin = project.getPlugins().findPlugin("com.google.firebase.firebase-perf");
        if (plugin == null) {
            return null;
        }
        try {
            Method getPluginVersion = plugin.getClass().getMethod("getPluginVersion", new Class[0]);
            return getPluginVersion.invoke(null, new Object[0]).toString();
        }
        catch (Throwable e) {
            return "unknown";
        }
    }
}

