/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.ide.dependencies.ArtifactUtils;
import com.android.build.gradle.internal.ide.dependencies.BuildIdentifierMethods;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;

public class AndroidDependenciesRenderer
extends TextReportRenderer {
    private final MavenCoordinatesCacheBuildService mavenCoordinatesCacheBuildService;
    private boolean hasConfigs;
    private boolean hasCyclicDependencies;
    private GraphRenderer renderer;

    public AndroidDependenciesRenderer(MavenCoordinatesCacheBuildService mavenCoordinatesCacheBuildService) {
        this.mavenCoordinatesCacheBuildService = mavenCoordinatesCacheBuildService;
    }

    public void startProject(ProjectDetails project) {
        super.startProject(project);
        this.hasConfigs = false;
        this.hasCyclicDependencies = false;
    }

    public void completeProject(ProjectDetails project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No dependencies");
        }
        super.completeProject(project);
    }

    public void startComponent(ComponentCreationConfig component2) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.renderer.visit(styledTextOutput -> this.getTextOutput().withStyle(StyledTextOutput.Style.Header).text((Object)component2.getName()), true);
    }

    public void render(ComponentCreationConfig component2) {
        Set<ResolvedArtifact> compileArtifacts = ArtifactUtils.getArtifactsForComponent(component2, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH);
        this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)component2.getVariantDependencies().getCompileClasspath().getName());
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)" - Dependencies for compilation");
        this.getTextOutput().println();
        this.renderer.startChildren();
        this.render((List<ResolvedArtifact>)ImmutableList.copyOf(compileArtifacts));
        this.renderer.completeChildren();
        Set<ResolvedArtifact> runtimeArtifacts = ArtifactUtils.getArtifactsForComponent(component2, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH);
        this.getTextOutput().println();
        this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)component2.getVariantDependencies().getRuntimeClasspath().getName());
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)" - Dependencies for runtime/packaging");
        this.getTextOutput().println();
        this.renderer.startChildren();
        this.render((List<ResolvedArtifact>)ImmutableList.copyOf(runtimeArtifacts));
        this.renderer.completeChildren();
    }

    public void complete() {
        if (this.hasCyclicDependencies) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"\n(*) - dependencies omitted (listed previously)");
        }
        super.complete();
    }

    private void render(List<ResolvedArtifact> artifacts2) {
        int count = artifacts2.size();
        for (int i = 0; i < count; ++i) {
            ResolvedArtifact artifact = artifacts2.get(i);
            this.renderer.visit(styledTextOutput -> {
                String text;
                ComponentIdentifier id = artifact.getComponentIdentifier();
                if (id instanceof ProjectComponentIdentifier) {
                    String projectId = BuildIdentifierMethods.getIdString((ProjectComponentIdentifier)id);
                    if (artifact.isWrappedModule()) {
                        if (artifact.getArtifactFile() == null) {
                            text = String.format("%s", projectId);
                        } else {
                            String file = artifact.getArtifactFile().getAbsolutePath();
                            text = String.format("%s (file: %s)", projectId, file);
                        }
                    } else if (artifact.getDependencyType() == ResolvedArtifact.DependencyType.ANDROID) {
                        String variant = artifact.getVariantName();
                        text = String.format("%s (variant: %s)", projectId, variant);
                    } else {
                        text = projectId;
                    }
                } else {
                    text = id instanceof ModuleComponentIdentifier ? artifact.computeModelAddress(this.mavenCoordinatesCacheBuildService) : (artifact.getArtifactFile() == null ? id.getDisplayName() : artifact.getArtifactFile().getAbsolutePath());
                }
                this.getTextOutput().text((Object)text);
            }, i == count - 1);
        }
    }
}

